/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra.pressure.function;

import com.github.jbgust.jsrm.infra.function.NaNThrowExceptionFunction;

public class LowKnFunction
extends NaNThrowExceptionFunction {
    public static final double LOW_KN_MASS_STORAGE_RATE = 1.0E-4;

    public LowKnFunction() {
        super("lowKn", 2);
    }

    @Override
    public double runFunction(double ... doubles) {
        double useSafeKn = doubles[1];
        double massStorageRateResult = doubles[0];
        if (useSafeKn == 1.0 && massStorageRateResult < 0.0) {
            return 1.0E-4;
        }
        return massStorageRateResult;
    }
}

