/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.application.motor.grain.core;

import com.github.jbgust.jsrm.application.motor.grain.GrainSurface;

public abstract class ExtrudedGrain {
    private boolean foreEndInhibited = false;
    private boolean aftEndInhibited = false;
    private double length = 100.0;
    private double endLight = 0.0;

    protected int numberOfBurningEnds(double regression) {
        if (regression < this.endLight) {
            return 0;
        }
        return (this.foreEndInhibited ? 0 : 1) + (this.aftEndInhibited ? 0 : 1);
    }

    public double regressedLength(double regression) {
        if (regression < this.endLight) {
            return this.length;
        }
        return this.length - (regression - this.endLight) * (double)this.numberOfBurningEnds(regression);
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setForeEndInhibited(GrainSurface grainSurface) {
        this.foreEndInhibited = grainSurface == GrainSurface.INHIBITED;
    }

    public void setAftEndInhibited(GrainSurface grainSurface) {
        this.aftEndInhibited = grainSurface == GrainSurface.INHIBITED;
    }

    public boolean isForeEndInhibited() {
        return this.foreEndInhibited;
    }

    public boolean isAftEndInhibited() {
        return this.aftEndInhibited;
    }
}

