/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbgust.jsrm.infra;

import com.github.jbgust.jsrm.infra.JSRMConstant;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.objecthunter.exp4j.function.Function;

public class FormulaConfiguration {
    private static final String MISSING_DEPENDENCY_ERROR = "%s is declared as dependency, but not used in the formula : %s";
    private static final String NOT_PREVIOUS_FORMULA_REGEX = "%s(?!_previous)";
    private final String formula;
    private String[] dependencies = new String[0];
    private JSRMConstant[] constants = new JSRMConstant[0];
    private String[] variables = new String[0];
    private Function[] functions = new Function[0];

    public FormulaConfiguration(String formula) {
        this.formula = formula;
    }

    public FormulaConfiguration withDependencies(String ... dependencies) {
        this.checkUnusedDependencies(dependencies);
        this.dependencies = dependencies;
        return this;
    }

    public FormulaConfiguration withConstants(JSRMConstant ... constants) {
        this.constants = constants;
        return this;
    }

    public FormulaConfiguration withVariables(String ... variables) {
        this.variables = variables;
        return this;
    }

    public FormulaConfiguration withFunctions(Function ... functions) {
        this.functions = functions;
        return this;
    }

    public String getFormula() {
        return this.formula;
    }

    public Function[] getFunctions() {
        return this.functions;
    }

    public String[] getDependencies() {
        return this.dependencies;
    }

    public JSRMConstant[] getConstants() {
        return this.constants;
    }

    public String[] getVariables() {
        return this.variables;
    }

    private void checkUnusedDependencies(String[] dependencies) {
        Stream.of(dependencies).forEach(dependency -> Preconditions.checkArgument((boolean)Pattern.compile(String.format(NOT_PREVIOUS_FORMULA_REGEX, dependency)).matcher(this.formula).find(), (Object)String.format(MISSING_DEPENDENCY_ERROR, dependency, this.formula)));
    }
}

