/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller;

import com.github.rcaller.exception.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TempFileService {
    private static final Logger logger = Logger.getLogger(TempFileService.class.getName());
    private ArrayList<File> tempFiles = new ArrayList();

    public File createTempFile(String prefix, String suffix) throws IOException {
        File f = File.createTempFile(prefix, suffix);
        this.tempFiles.add(f);
        return f;
    }

    public void deleteRCallerTempFiles() {
        for (File tempFile : this.tempFiles) {
            if (tempFile.delete()) continue;
            logger.log(Level.WARNING, "Couldn't delete file ".concat(tempFile.getName()));
        }
        this.tempFiles.clear();
    }

    public File createOutputFile() {
        try {
            return this.createTempFile("ROutput", "");
        }
        catch (Exception e) {
            throw new ExecutionException("Can not create a temporary file for storing the R results: " + e.getMessage());
        }
    }

    public File createControlFile() {
        try {
            return this.createTempFile("RControl", "");
        }
        catch (Exception e) {
            throw new ExecutionException("Can not create a temporary file for storing the R results: " + e.getMessage());
        }
    }
}

