/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller.datatypes;

import com.github.rcaller.util.DataFrameUtil;

public class DataFrame {
    private Object[][] objects;
    private String[] names;

    private DataFrame(Object[][] objects, String[] names) {
        this.objects = objects;
        this.names = names;
    }

    public static DataFrame create(int n, int m) {
        return new DataFrame(DataFrameUtil.createEmptyObjectsMatrix(n, m), DataFrameUtil.createDefaultNamesArray(n));
    }

    public static DataFrame create(Object[][] objects, String[] names) {
        if (objects.length != names.length) {
            throw new IllegalArgumentException("The number of columns of the data frame is not equal with the number of names!");
        }
        return new DataFrame(objects, names);
    }

    public Object[] getColumn(int i) {
        if (i >= this.getNumberOfColumns() || i < 0) {
            throw new IllegalArgumentException("Requested index is greater than the number of columns - 1!");
        }
        return this.objects[i];
    }

    public Object[] getRow(int i) {
        if (i >= this.getNumberOfRows() || i < 0) {
            throw new IllegalArgumentException("Requested index is greater than the number of rows - 1!");
        }
        Object[] row = new Object[this.objects.length];
        for (int j = 0; j < this.objects.length; ++j) {
            row[j] = this.objects[j][i];
        }
        return row;
    }

    public Object[][] getObjects() {
        return this.objects;
    }

    public String[] getNames() {
        return this.names;
    }

    public int getNumberOfColumns() {
        return this.objects.length;
    }

    public int getNumberOfRows() {
        return this.objects[0].length;
    }

    public Object getObject(int n, int m) {
        if (n >= this.getNumberOfColumns() || n < 0 && m > this.getNumberOfRows() || m < 0) {
            throw new IllegalArgumentException("Given indexes are greater than the dimensions of the data frame!");
        }
        if (n >= this.getNumberOfColumns() || n < 0) {
            throw new IllegalArgumentException("Requested index is greater than the number of columns - 1!");
        }
        if (m >= this.getNumberOfRows() || m < 0) {
            throw new IllegalArgumentException("Requested index is greater than the number of rows - 1!");
        }
        return this.objects[n][m];
    }
}

