/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller.datatypes;

import com.github.rcaller.datatypes.SVD;
import com.github.rcaller.exception.ExecutionException;
import com.github.rcaller.rstuff.RCaller;
import com.github.rcaller.rstuff.RCode;
import com.github.rcaller.rstuff.RService;

public class RealMatrix {
    private RService service;
    private RCaller rcaller;
    private RCode code;
    private String name;
    private String HashString;

    public RCaller getRCaller() {
        return this.rcaller;
    }

    public RealMatrix(RService service) {
        this.service = service;
        this.rcaller = service.getRCaller();
        this.code = this.service.getRCode();
        this.name = "MAT" + String.valueOf(Math.round(Math.random() * 100000.0));
        this.HashString = "RCALLER" + String.valueOf(this.hashCode());
        this.code.addRCode(this.HashString + " <- 3");
        this.rcaller.runAndReturnResultOnline(this.HashString);
    }

    public RealMatrix(String pathToR, String name) {
        this.service = new RService();
        this.rcaller = this.service.getRCaller();
        this.code = this.service.getRCode();
        this.name = name;
        this.HashString = "RCALLER" + String.valueOf(this.hashCode());
        this.code.addRCode(this.HashString + " <- 3");
        this.rcaller.runAndReturnResultOnline(this.HashString);
    }

    public void setData(double[][] data) {
        this.code.clearOnline();
        this.code.addDoubleMatrix(this.name, data);
        this.rcaller.runAndReturnResultOnline(this.HashString);
    }

    public int[] getDimensions() {
        this.code.clearOnline();
        this.rcaller.runAndReturnResultOnline(this.name);
        return this.rcaller.getParser().getDimensions(this.name);
    }

    public double[][] getData() {
        this.code.clearOnline();
        this.code.addRCode(this.HashString + "<- t(" + this.name + ")");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        int[] dims = this.rcaller.getParser().getDimensions(this.HashString);
        return this.rcaller.getParser().getAsDoubleMatrix(this.HashString, dims[0], dims[1]);
    }

    public double[] getColumn(int column) {
        if (column == 0) {
            throw new ExecutionException("getColumn: Column number can not be zero. R indices start from 1");
        }
        this.code.clearOnline();
        this.code.addRCode(this.HashString + "<- " + this.name + "[," + column + "]");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        return this.rcaller.getParser().getAsDoubleArray(this.HashString);
    }

    public double[][] getColumns(int[] columns) {
        int i;
        for (i = 0; i < columns.length; ++i) {
            if (columns[i] != 0) continue;
            throw new ExecutionException("getColumns: Column number can not be zero. R indices start from 1");
        }
        this.code.clearOnline();
        this.code.addRCode(this.HashString + "<- t(" + this.name + "[,c(");
        for (i = 0; i < columns.length; ++i) {
            this.code.addRCode(String.valueOf(columns[i]));
            if (i == columns.length - 1) continue;
            this.code.addRCode(",");
        }
        this.code.addRCode(")])");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        int[] dims = this.rcaller.getParser().getDimensions(this.HashString);
        return this.rcaller.getParser().getAsDoubleMatrix(this.HashString, dims[0], dims[1]);
    }

    public double[] getRow(int row) {
        if (row == 0) {
            throw new ExecutionException("getRow: Row number can not be zero. R indices start from 1");
        }
        this.code.clearOnline();
        this.code.addRCode(this.HashString + "<- " + this.name + "[" + row + ",]");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        return this.rcaller.getParser().getAsDoubleArray(this.HashString);
    }

    public double[][] getRows(int[] rows) {
        int i;
        for (i = 0; i < rows.length; ++i) {
            if (rows[i] != 0) continue;
            throw new ExecutionException("getRows: Row number can not be zero. R indices start from 1");
        }
        this.code.clearOnline();
        this.code.addRCode(this.HashString + "<- t(" + this.name + "[c(");
        for (i = 0; i < rows.length; ++i) {
            this.code.addRCode(String.valueOf(rows[i]));
            if (i == rows.length - 1) continue;
            this.code.addRCode(",");
        }
        this.code.addRCode("),])");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        int[] dims = this.rcaller.getParser().getDimensions(this.HashString);
        return this.rcaller.getParser().getAsDoubleMatrix(this.HashString, dims[0], dims[1]);
    }

    public double getDeterminant() {
        this.code.clearOnline();
        this.code.addRCode(this.HashString + " <- det(" + this.name + ")");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        double det = this.rcaller.getParser().getAsDoubleArray(this.HashString)[0];
        return det;
    }

    public RealMatrix getInverse() {
        this.code.clearOnline();
        this.code.addRCode(this.HashString + " <- t(solve(" + this.name + "))");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        double[][] mat = this.rcaller.getParser().getAsDoubleMatrix(this.HashString, 2, 2);
        RealMatrix matnew = new RealMatrix(this.service);
        matnew.setData(mat);
        return matnew;
    }

    public double[] getDiagonal() {
        this.code.clearOnline();
        this.code.addRCode(this.HashString + " <- diag(" + this.name + ")");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        return this.rcaller.getParser().getAsDoubleArray(this.HashString);
    }

    public double getTrace() {
        this.code.clearOnline();
        this.code.addRCode(this.HashString + " <- sum(diag(" + this.name + "))");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        return this.rcaller.getParser().getAsDoubleArray(this.HashString)[0];
    }

    public RealMatrix getTranspose() {
        this.code.clearOnline();
        this.rcaller.runAndReturnResultOnline(this.name);
        int[] dims = this.rcaller.getParser().getDimensions(this.name);
        double[][] mat = this.rcaller.getParser().getAsDoubleMatrix(this.name, dims[0], dims[1]);
        RealMatrix matnew = new RealMatrix(this.service);
        matnew.setData(mat);
        return matnew;
    }

    public RealMatrix product(double[][] another) {
        String anotherHashString = "RCALLER" + String.valueOf(another.hashCode());
        this.code.clearOnline();
        this.code.addDoubleMatrix(anotherHashString, another);
        this.code.addRCode(this.HashString + " <- " + this.name + " %*% " + anotherHashString);
        this.rcaller.runAndReturnResultOnline(this.HashString);
        int[] dims = this.rcaller.getParser().getDimensions(this.HashString);
        double[][] mat = this.rcaller.getParser().getAsDoubleMatrix(this.HashString, dims[0], dims[1]);
        RealMatrix matnew = new RealMatrix(this.service);
        matnew.setData(mat);
        return matnew;
    }

    public RealMatrix product(RealMatrix another) {
        return this.product(another.getData());
    }

    public RealMatrix sum(double[][] another) {
        String anotherHashString = "RCALLER" + String.valueOf(another.hashCode());
        this.code.clearOnline();
        this.code.addDoubleMatrix(anotherHashString, another);
        this.code.addRCode(this.HashString + " <- " + this.name + " + " + anotherHashString);
        this.rcaller.runAndReturnResultOnline(this.HashString);
        int[] dims = this.rcaller.getParser().getDimensions(this.HashString);
        double[][] mat = this.rcaller.getParser().getAsDoubleMatrix(this.HashString, dims[0], dims[1]);
        RealMatrix matnew = new RealMatrix(this.service);
        matnew.setData(mat);
        return matnew;
    }

    public RealMatrix sum(RealMatrix another) {
        return this.sum(another.getData());
    }

    public RealMatrix productWithScaler(double scaler) {
        this.code.clearOnline();
        this.code.addRCode(this.HashString + " <- " + this.name + " * " + String.valueOf(scaler));
        this.rcaller.runAndReturnResultOnline(this.HashString);
        int[] dims = this.rcaller.getParser().getDimensions(this.HashString);
        double[][] mat = this.rcaller.getParser().getAsDoubleMatrix(this.HashString, dims[0], dims[1]);
        RealMatrix matnew = new RealMatrix(this.service);
        matnew.setData(mat);
        return matnew;
    }

    public RealMatrix subtract(double[][] another) {
        String anotherHashString = "RCALLER" + String.valueOf(another.hashCode());
        this.code.clearOnline();
        this.code.addDoubleMatrix(anotherHashString, another);
        this.code.addRCode(this.HashString + " <- " + this.name + " - " + anotherHashString);
        this.rcaller.runAndReturnResultOnline(this.HashString);
        int[] dims = this.rcaller.getParser().getDimensions(this.HashString);
        double[][] mat = this.rcaller.getParser().getAsDoubleMatrix(this.HashString, dims[0], dims[1]);
        RealMatrix matnew = new RealMatrix(this.service);
        matnew.setData(mat);
        return matnew;
    }

    public RealMatrix subtract(RealMatrix another) {
        return this.subtract(another.getData());
    }

    public double[] getEigenValues() {
        this.code.clearOnline();
        this.code.addRCode(this.HashString + " <- eigen(" + this.name + ")$values");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        return this.rcaller.getParser().getAsDoubleArray(this.HashString);
    }

    public RealMatrix getEigenVectors() {
        this.code.clearOnline();
        this.code.addRCode(this.HashString + " <- t(eigen(" + this.name + ")$vectors)");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        int[] dims = this.rcaller.getParser().getDimensions(this.HashString);
        double[][] result = this.rcaller.getParser().getAsDoubleMatrix(this.HashString, dims[0], dims[1]);
        RealMatrix newmat = new RealMatrix(this.service);
        newmat.setData(result);
        return newmat;
    }

    public SVD getSVD() {
        SVD svd = new SVD();
        this.code.clearOnline();
        this.code.addRCode(this.HashString + " <- svd(" + this.name + ")");
        this.rcaller.runAndReturnResultOnline(this.HashString);
        double[] d = this.rcaller.getParser().getAsDoubleArray("d");
        double[][] u = this.rcaller.getParser().getAsDoubleMatrix("u");
        double[][] v = this.rcaller.getParser().getAsDoubleMatrix("v");
        RealMatrix uMatrix = new RealMatrix(this.service);
        RealMatrix vMatrix = new RealMatrix(this.service);
        svd.setD(d);
        uMatrix.setData(u);
        svd.setU(uMatrix);
        vMatrix.setData(v);
        svd.setV(vMatrix);
        return svd;
    }
}

