/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller.rstuff;

import com.github.rcaller.EventHandler;
import com.github.rcaller.MessageSaver;
import com.github.rcaller.TempFileService;
import com.github.rcaller.exception.ExecutionException;
import com.github.rcaller.exception.ParseException;
import com.github.rcaller.graphics.GraphicsTheme;
import com.github.rcaller.rstuff.FailurePolicy;
import com.github.rcaller.rstuff.RCallerOptions;
import com.github.rcaller.rstuff.RCode;
import com.github.rcaller.rstuff.ROutputParser;
import com.github.rcaller.rstuff.RStreamHandler;
import com.github.rcaller.util.Globals;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RCaller {
    private static final Logger logger = Logger.getLogger(RCaller.class.getName());
    private RCode rCode;
    private ROutputParser parser;
    private Process process;
    private String tmpDir;
    private OutputStream rInput;
    private RStreamHandler rOutput;
    private RStreamHandler rError;
    private MessageSaver errorMessageSaver;
    private TempFileService tempFileService;
    private RCallerOptions rCallerOptions;
    private Random rand = new Random(System.currentTimeMillis());

    protected RCaller(RCode rCode, ROutputParser parser, RStreamHandler rOutput, RStreamHandler rError, MessageSaver messageSaver, TempFileService tempFileService, RCallerOptions rCallerOptions) {
        this.rCode = rCode;
        this.parser = parser;
        this.rOutput = rOutput;
        this.rError = rError;
        this.errorMessageSaver = messageSaver;
        this.tempFileService = tempFileService;
        this.rCallerOptions = rCallerOptions;
        this.rError.addEventHandler(this.errorMessageSaver);
    }

    public static RCaller create() {
        return new RCaller(RCode.create(), new ROutputParser(), new RStreamHandler(null, "Output"), new RStreamHandler(null, "Error"), new MessageSaver(), new TempFileService(), RCallerOptions.create());
    }

    public static RCaller create(RCallerOptions rCallerOptions) {
        return new RCaller(RCode.create(), new ROutputParser(), new RStreamHandler(null, "Output"), new RStreamHandler(null, "Error"), new MessageSaver(), new TempFileService(), rCallerOptions);
    }

    public static RCaller create(RCode rcode, RCallerOptions rCallerOptions) {
        return new RCaller(rcode, new ROutputParser(), new RStreamHandler(null, "Output"), new RStreamHandler(null, "Error"), new MessageSaver(), new TempFileService(), rCallerOptions);
    }

    public boolean stopStreamConsumers() {
        this.rOutput.stop();
        this.rError.stop();
        return this.rOutput.isAlive() && this.rError.isAlive();
    }

    public void startStreamConsumers(Process process) {
        this.rOutput.setStream(process.getInputStream());
        this.rOutput.start();
        this.rError.setStream(process.getErrorStream());
        this.rError.start();
    }

    public String getCranRepos() {
        return Globals.cranRepos;
    }

    public ROutputParser getParser() {
        return this.parser;
    }

    public RCode getRCode() {
        return this.rCode;
    }

    public void setRCode(RCode rcode) {
        this.rCode = rcode;
    }

    public void setGraphicsTheme(GraphicsTheme theme) {
        Globals.theme = theme;
    }

    public void deleteTempFiles() {
        this.tempFileService.deleteRCallerTempFiles();
        this.rCode.deleteTempFiles();
    }

    private File createRSourceFile() throws ExecutionException {
        File f;
        BufferedWriter writer = null;
        try {
            f = this.tempFileService.createTempFile("rCaller", "");
        }
        catch (IOException e) {
            throw new ExecutionException("Can not open a temporary file for storing the R Code: " + e.toString());
        }
        try {
            writer = new BufferedWriter(new FileWriter(f));
            writer.write(this.rCode.toString());
            writer.flush();
        }
        catch (IOException e) {
            throw new ExecutionException("Can not write to temporary file for storing the R Code: " + e.toString());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
            }
        }
        return f;
    }

    public void runOnly() throws ExecutionException {
        this.rCode.getCode().append("q(").append("\"").append("yes").append("\"").append(")\n");
        this.runRCode();
    }

    private Process exec(String command) throws IOException {
        String langEnv;
        String[] cmd = command.split(" ");
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Map<String, String> env = pb.environment();
        String locale = Globals.standardLocale.toString();
        if (locale.equals("en") && ("C.UTF-8".equals(langEnv = System.getenv().get("LANG")) || "C".equals(langEnv) || "POSIX".equals(langEnv))) {
            locale = "C";
        }
        String localeAndCharset = String.join((CharSequence)".", locale, Globals.standardCharset.toString());
        env.put("LC_COLLATE", localeAndCharset);
        env.put("LC_CTYPE", localeAndCharset);
        env.put("LC_MESSAGES", localeAndCharset);
        env.put("LC_MONETARY", localeAndCharset);
        env.put("LC_NUMERIC", localeAndCharset);
        env.put("LC_TIME", localeAndCharset);
        env.put("LC_ALL", localeAndCharset);
        return pb.start();
    }

    private void runRCode() throws ExecutionException {
        int returnCode;
        if (this.rCallerOptions.getrScriptExecutable() == null) {
            throw new ExecutionException("RscriptExecutable is not defined. Please set this variable to full path of Rscript executable binary file.");
        }
        File rSourceFile = this.createRSourceFile();
        this.errorMessageSaver.resetMessage();
        try {
            this.process = this.exec(this.rCallerOptions.getrScriptExecutable() + " " + Globals.getSystemSpecificRPathParameter(rSourceFile));
            this.startStreamConsumers(this.process);
            returnCode = this.process.waitFor();
        }
        catch (Exception e) {
            throw new ExecutionException("Can not run " + this.rCallerOptions.getrScriptExecutable() + ". Reason: " + e.toString());
        }
        finally {
            this.stopStreamConsumers();
        }
        if (returnCode != 0) {
            throw new ExecutionException("R command failed with error. Reason: " + this.errorMessageSaver.getMessage());
        }
    }

    public void runAndReturnResultOnline(String var) throws ExecutionException {
        this.rCallerOptions.resetRetries();
        boolean done = false;
        do {
            File resultReadyControlFile;
            File outputFile;
            if (this.rCallerOptions.getRetries() > 0) {
                logger.log(Level.INFO, "Retrying online R execution");
            }
            if (this.rCallerOptions.getrExecutable() == null && this.handleRFailure("RExecutable is not defined.Please set this variable to full path of R executable binary file.")) continue;
            try {
                outputFile = this.tempFileService.createOutputFile();
                resultReadyControlFile = this.tempFileService.createControlFile();
            }
            catch (Exception e) {
                if (this.handleRFailure("Can not create a temporary file for storing the R results: " + e.getMessage())) continue;
                throw new RuntimeException("Output file couldn't be created!");
            }
            this.rCode.appendStandardCodeToAppend(outputFile, var);
            String resultReadyVarName = "resultReady" + Math.abs(this.rand.nextLong());
            this.rCode.addRCode(resultReadyVarName + " <- 1");
            this.rCode.appendStandardCodeToAppend(resultReadyControlFile, resultReadyVarName);
            if (this.rInput == null || this.rOutput == null || this.rError == null || this.process == null) {
                try {
                    this.startOnlineProcess();
                }
                catch (Exception e) {
                    if (this.handleRFailure("Can not run " + this.rCallerOptions.getrExecutable() + ". Reason: " + e.toString())) continue;
                }
            }
            try {
                this.rInput.write(this.rCode.toString().getBytes(Globals.standardCharset));
                this.rInput.flush();
            }
            catch (IOException e) {
                if (this.handleRFailure("Can not send the source code to R file due to: " + e.toString())) continue;
            }
            try {
                this.waitRExecute(resultReadyControlFile);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.isProcessAlive() && this.errorMessageSaver.getMessage().length() > 0 && this.handleRFailure("R stderr: " + this.errorMessageSaver.getMessage())) continue;
            this.parser.setXMLFile(outputFile);
            try {
                this.parser.parse();
            }
            catch (ParseException e) {
                if (this.handleRFailure("Can not handle R results due to : " + e.toString())) continue;
            }
            done = true;
        } while (!done && this.isProcessAlive());
    }

    private void waitRExecute(File controlFile) throws InterruptedException {
        long startedAt = System.currentTimeMillis();
        boolean processKilled = false;
        while (!processKilled && controlFile.length() < 1L && this.isProcessAlive()) {
            Thread.sleep(1L);
            if (System.currentTimeMillis() - startedAt <= this.rCallerOptions.getMaxWaitTime()) continue;
            this.process.destroy();
            this.stopStreamConsumers();
            processKilled = true;
        }
    }

    private void startOnlineProcess() throws IOException {
        String commandline = this.rCallerOptions.getrExecutable() + this.rCallerOptions.getStartUpOptionsAsCommand();
        this.process = this.exec(commandline);
        this.rInput = this.process.getOutputStream();
        this.startStreamConsumers(this.process);
        try {
            RCode getTmpDirCode = RCode.create();
            File getTmpDirFile = this.tempFileService.createTempFile("getTmpDir", "");
            String tempDirOutVarName = "tempDirOut" + Math.abs(this.rand.nextLong());
            getTmpDirCode.addRCode(tempDirOutVarName + " <- tempdir()");
            getTmpDirCode.appendStandardCodeToAppend(getTmpDirFile, tempDirOutVarName);
            File resultReadyControlFile = this.tempFileService.createControlFile();
            String resultReadyVarName = "resultReady" + Math.abs(this.rand.nextLong());
            getTmpDirCode.addRCode(resultReadyVarName + " <- 1");
            getTmpDirCode.appendStandardCodeToAppend(resultReadyControlFile, resultReadyVarName);
            this.rInput.write(getTmpDirCode.toString().getBytes(Globals.standardCharset));
            this.rInput.flush();
            this.waitRExecute(resultReadyControlFile);
            this.parser.setXMLFile(getTmpDirFile);
            this.parser.parse();
            this.tmpDir = this.parser.getAsStringArray(tempDirOutVarName)[0];
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "Could not get R tempdir", e);
        }
    }

    private boolean isProcessAlive() {
        if (this.process == null) {
            return false;
        }
        return this.process.isAlive();
    }

    @Deprecated
    public void StopRCallerOnline() {
        this.stopRCallerOnline();
    }

    public void stopRCallerOnline() {
        if (this.process != null) {
            try {
                this.process.getOutputStream().write("q(\"no\")\n".getBytes(Globals.standardCharset));
                this.process.getOutputStream().flush();
                this.process.getOutputStream().close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage());
            }
            if (Globals.isWindows()) {
                this.process.destroy();
            }
        }
    }

    @Deprecated
    public void StopRCallerAsync() {
        this.stopRCallerAsync();
    }

    public void stopRCallerAsync() {
        if (this.process != null) {
            this.process.destroy();
            this.stopStreamConsumers();
            this.process = null;
            if (this.tmpDir != null) {
                this.deleteDirectory(new File(this.tmpDir));
            }
        }
    }

    private void deleteDirectory(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.deleteDirectory(c);
            }
        }
        if (!f.delete()) {
            throw new ExecutionException("Failed to delete file: " + f);
        }
    }

    private boolean handleRFailure(String reason) throws ExecutionException {
        int maxFailures = 0;
        if (this.rCallerOptions.getFailurePolicy() == FailurePolicy.CONTINUE) {
            maxFailures = -1;
        }
        if (this.rCallerOptions.getFailurePolicy() == FailurePolicy.RETRY_1) {
            maxFailures = 1;
        }
        if (this.rCallerOptions.getFailurePolicy() == FailurePolicy.RETRY_5) {
            maxFailures = 5;
        }
        if (this.rCallerOptions.getFailurePolicy() == FailurePolicy.RETRY_10) {
            maxFailures = 10;
        }
        if (this.rCallerOptions.getFailurePolicy() == FailurePolicy.RETRY_FOREVER) {
            maxFailures = Integer.MAX_VALUE;
        }
        if (this.rCallerOptions.getRetries() < maxFailures) {
            this.rCallerOptions.incrementRetries();
            return true;
        }
        throw new ExecutionException(reason + " Maximum number of retries exceeded.");
    }

    public void runAndReturnResult(String var) throws ExecutionException {
        File outputFile = this.tempFileService.createOutputFile();
        this.rCode.appendStandardCodeToAppend(outputFile, var);
        this.runRCode();
        this.parser.setXMLFile(outputFile);
        try {
            this.parser.parse();
        }
        catch (Exception e) {
            Logger.getLogger(RCaller.class.getName()).log(Level.INFO, this.rCode.toString());
            throw new ParseException("Can not handle R results due to : " + e.getMessage());
        }
    }

    public void redirectROutputToFile(String name, boolean appendToExisting) throws FileNotFoundException {
        this.redirectROutputToStream(new FileOutputStream(name, appendToExisting));
    }

    public void redirectROutputToStream(final OutputStream o) {
        EventHandler eh = new EventHandler(){

            @Override
            public void messageReceived(String senderName, String msg) {
                try {
                    o.write(senderName.getBytes(Globals.standardCharset));
                    o.write(":".getBytes(Globals.standardCharset));
                    o.write(msg.getBytes(Globals.standardCharset));
                    o.write("\n".getBytes(Globals.standardCharset));
                    o.flush();
                }
                catch (IOException ex) {
                    Logger.getLogger(RCaller.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.rOutput.addEventHandler(eh);
        this.rError.addEventHandler(eh);
    }

    public RCallerOptions getRCallerOptions() {
        return this.rCallerOptions;
    }
}

