/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller.rstuff;

import com.github.rcaller.FunctionCall;
import com.github.rcaller.TempFileService;
import com.github.rcaller.datatypes.DataFrame;
import com.github.rcaller.exception.ExecutionException;
import com.github.rcaller.graphics.GraphicsType;
import com.github.rcaller.rstuff.RPlotViewer;
import com.github.rcaller.util.Globals;
import com.github.rcaller.util.RCodeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.ImageIcon;

public class RCode {
    private StringBuilder code = new StringBuilder();
    private TempFileService tempFileService = null;

    private RCode() {
    }

    public static RCode create() {
        RCode rCode = new RCode();
        rCode.clear();
        return rCode;
    }

    public static RCode create(StringBuffer stringBuffer) {
        RCode rCode = RCode.create();
        rCode.clear();
        rCode.getCode().append(stringBuffer.toString());
        return rCode;
    }

    public void setCode(StringBuffer sb) {
        this.code = new StringBuilder();
        this.clear();
        this.code.append(sb.toString());
    }

    public void setCode(StringBuilder sb) {
        this.code = new StringBuilder();
        this.clear();
        this.code.append((CharSequence)sb);
    }

    public StringBuilder getCode() {
        return this.code;
    }

    public final void clear() {
        this.code.setLength(0);
        try {
            String s;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("runiversal.r");
            InputStreamReader inputStreamReader = new InputStreamReader(is);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((s = bufferedReader.readLine()) != null) {
                this.addRCode(s);
            }
            this.addRCode("\n");
        }
        catch (IOException e) {
            throw new ExecutionException("runiversal.R in package: " + e.toString());
        }
    }

    public void appendStandardCodeToAppend(File outputFile, String var) {
        this.code.append("cat(makexml(obj=").append(var).append(", name=\"").append(var).append("\"), file=\"").append(outputFile.getAbsolutePath().replace("\\", "/")).append("\")\n");
    }

    public void clearOnline() {
        this.code.setLength(0);
    }

    public void addRCode(String code) {
        this.code.append(code).append("\n");
    }

    public void addStringArray(String name, String[] arr) {
        RCodeUtils.addStringArray(this.code, name, arr, false);
    }

    public void addDoubleArray(String name, double[] arr) {
        RCodeUtils.addDoubleArray(this.code, name, arr, false);
    }

    public void addLongArray(String name, long[] arr) {
        RCodeUtils.addLongArray(this.code, name, arr, false);
    }

    public void addFloatArray(String name, float[] arr) {
        RCodeUtils.addFloatArray(this.code, name, arr, false);
    }

    public void addIntArray(String name, int[] arr) {
        RCodeUtils.addIntArray(this.code, name, arr, false);
    }

    public void addShortArray(String name, short[] arr) {
        RCodeUtils.addShortArray(this.code, name, arr, false);
    }

    public void addLogicalArray(String name, boolean[] arr) {
        RCodeUtils.addLogicalArray(this.code, name, arr, false);
    }

    public void addJavaObject(Object o) throws IllegalAccessException {
        RCodeUtils.addJavaObject(this.code, o, false);
    }

    public void addDoubleMatrix(String name, double[][] matrix) {
        RCodeUtils.addDoubleMatrix(this.code, name, matrix, false);
    }

    public void addFunctionCall(String returnVarName, FunctionCall fc) {
        this.code.append(fc.generateCode(returnVarName));
    }

    public void addDouble(String name, double d) {
        RCodeUtils.addDouble(this.code, name, d, false);
    }

    public void addInt(String name, int i) {
        RCodeUtils.addInt(this.code, name, i, false);
    }

    public void addLong(String name, long l) {
        RCodeUtils.addLong(this.code, name, l, false);
    }

    public void addFloat(String name, float f) {
        RCodeUtils.addFloat(this.code, name, f, false);
    }

    public void addShort(String name, short s) {
        RCodeUtils.addShort(this.code, name, s, false);
    }

    public void addBoolean(String name, boolean b) {
        RCodeUtils.addBoolean(this.code, name, b, false);
    }

    public void addLogical(String name, boolean b) {
        this.addBoolean(name, b);
    }

    public void addString(String name, String value) {
        RCodeUtils.addString(this.code, name, value, false);
    }

    public void addDataFrame(String name, DataFrame dataFrame) {
        RCodeUtils.addDataFrame(this.code, name, dataFrame);
    }

    public File startPlot() throws IOException {
        return this.startPlot(GraphicsType.png);
    }

    public File startPlot(GraphicsType type) throws IOException {
        if (this.tempFileService == null) {
            this.tempFileService = new TempFileService();
        }
        File f = this.tempFileService.createTempFile("RPlot", "." + type.name());
        switch (type) {
            case png: {
                this.addRCode("png(\"" + f.toString().replace("\\", "/") + "\")");
                break;
            }
            case jpeg: {
                this.addRCode("jpeg(\"" + f.toString().replace("\\", "/") + "\")");
                break;
            }
            case tiff: {
                this.addRCode("tiff(\"" + f.toString().replace("\\", "/") + "\")");
                break;
            }
            case bmp: {
                this.addRCode("bmp(\"" + f.toString().replace("\\", "/") + "\")");
                break;
            }
            default: {
                this.addRCode("png(\"" + f.toString().replace("\\", "/") + "\")");
            }
        }
        this.addRCode(Globals.theme.generateRCode());
        return f;
    }

    public void endPlot() {
        this.addRCode("dev.off()");
    }

    public ImageIcon getPlot(File f) {
        return new ImageIcon(f.toString());
    }

    public void showPlot(File f) {
        ImageIcon plot = this.getPlot(f);
        RPlotViewer plotter = new RPlotViewer(plot);
        plotter.setVisible(true);
    }

    public void R_require(String pkg) {
        this.code = this.code.insert(0, "require(" + pkg + ")\n");
    }

    public void R_source(String sourceFile) {
        this.addRCode("source(\"" + sourceFile + "\")\n");
    }

    public void deleteTempFiles() {
        if (this.tempFileService != null) {
            this.tempFileService.deleteRCallerTempFiles();
        }
    }

    public String toString() {
        return this.code.toString();
    }
}

