/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller.rstuff;

import java.lang.reflect.Field;

public class RProcessStartUpOptions {
    private boolean save;
    private boolean noSave;
    private boolean noEnviron;
    private boolean noSiteFile;
    private boolean noInitFile;
    private boolean restore;
    private boolean noRestoreData;
    private boolean noRestoreHistory;
    private boolean noRestore;
    private boolean vanilla;
    private boolean noReadLine;
    private boolean quiet;
    private boolean silent;
    private boolean slave;
    private boolean interactive;
    private boolean verbose;
    private Integer maxPPSize;
    private Integer minNSize;
    private Integer minVSize;
    private String debugger;
    private String debuggerArgs;
    private String gui;
    private String arch;
    private String args;
    private String file;

    private RProcessStartUpOptions(boolean save, boolean noSave, boolean noEnviron, boolean noSiteFile, boolean noInitFile, boolean restore, boolean noRestoreData, boolean noRestoreHistory, boolean noRestore, boolean vanilla, boolean noReadLine, boolean quiet, boolean silent, boolean slave, boolean interactive, boolean verbose, Integer maxPPSize, Integer minNSize, Integer minVSize, String debugger, String debuggerArgs, String gui, String arch, String args, String file) {
        this.save = save;
        this.noSave = noSave;
        this.noEnviron = noEnviron;
        this.noSiteFile = noSiteFile;
        this.noInitFile = noInitFile;
        this.restore = restore;
        this.noRestoreData = noRestoreData;
        this.noRestoreHistory = noRestoreHistory;
        this.noRestore = noRestore;
        this.vanilla = vanilla;
        this.noReadLine = noReadLine;
        this.quiet = quiet;
        this.silent = silent;
        this.slave = slave;
        this.interactive = interactive;
        this.verbose = verbose;
        this.maxPPSize = maxPPSize;
        this.minNSize = minNSize;
        this.minVSize = minVSize;
        this.debugger = debugger;
        this.debuggerArgs = debuggerArgs;
        this.gui = gui;
        this.arch = arch;
        this.args = args;
        this.file = file;
    }

    public static RProcessStartUpOptions create() {
        return new RProcessStartUpOptions(false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, null, null, null, null, null, null, null, null, null);
    }

    public static RProcessStartUpOptions create(boolean save, boolean noSave, boolean noEnviron, boolean noSiteFile, boolean noInitFile, boolean restore, boolean noRestoreData, boolean noRestoreHistory, boolean noRestore, boolean vanilla, boolean noReadLine, boolean quiet, boolean silent, boolean slave, boolean interactive, boolean verbose, Integer maxPPSize, Integer minNSize, Integer minVSize, String debugger, String debuggerArgs, String gui, String arch, String args, String file) {
        return new RProcessStartUpOptions(save, noSave, noEnviron, noSiteFile, noInitFile, restore, noRestoreData, noRestoreHistory, noRestore, vanilla, noReadLine, quiet, silent, slave, interactive, verbose, maxPPSize, minNSize, minVSize, debugger, debuggerArgs, gui, arch, args, file);
    }

    public String getStartUpOptionsAsCommand() {
        Field[] fields = this.getClass().getDeclaredFields();
        String command = " ";
        for (Field field : fields) {
            if (field.getType().equals(Boolean.TYPE)) {
                command = command.concat(this.getCommandForBooleanField(field.getName()));
                continue;
            }
            if (field.getType().equals(Integer.class)) {
                command = command.concat(this.getCommandForIntegerField(field.getName()));
                continue;
            }
            if (field.getType().equals(String.class)) {
                String tempCommand;
                if (field.getName().equals("args") && !(tempCommand = this.getCommandForStringField(field.getName())).isEmpty()) {
                    return tempCommand;
                }
                command = command.concat(this.getCommandForStringField(field.getName()));
                continue;
            }
            throw new IllegalArgumentException("Unknown field type " + field.getType());
        }
        return command;
    }

    private String getCommandForBooleanField(String fieldName) {
        switch (fieldName) {
            case "save": {
                return this.save ? "--save " : "";
            }
            case "noSave": {
                return this.noSave ? "--no-save " : "";
            }
            case "noEnviron": {
                return this.noEnviron ? "--no-environ " : "";
            }
            case "noSiteFile": {
                return this.noSiteFile ? "--no-site-file " : "";
            }
            case "noInitFile": {
                return this.noInitFile ? "--no-init-file " : "";
            }
            case "restore": {
                return this.restore ? "--restore " : "";
            }
            case "noRestoreData": {
                return this.noRestoreData ? "--no-restore-data " : "";
            }
            case "noRestoreHistory": {
                return this.noRestoreHistory ? "--no-restore-history " : "";
            }
            case "noRestore": {
                return this.noRestore ? "--no-restore " : "";
            }
            case "vanilla": {
                return this.vanilla ? "--vanilla " : "";
            }
            case "noReadLine": {
                return this.noReadLine ? "--no-readline " : "";
            }
            case "quiet": {
                return this.quiet ? "--quiet " : "";
            }
            case "silent": {
                return this.silent ? "--silent " : "";
            }
            case "slave": {
                return this.slave ? "--slave " : "";
            }
            case "interactive": {
                return this.interactive ? "--interactive " : "";
            }
            case "verbose": {
                return this.verbose ? "--verbose " : "";
            }
        }
        throw new IllegalArgumentException("Unknown field: " + fieldName);
    }

    private String getCommandForIntegerField(String fieldName) {
        switch (fieldName) {
            case "maxPPSize": {
                return this.maxPPSize != null && this.maxPPSize >= 0 ? "--max-ppsize=" + this.maxPPSize + " " : "";
            }
            case "minNSize": {
                return this.minNSize != null && this.minNSize >= 0 ? "--min-nsize=" + this.minNSize + " " : "";
            }
            case "minVSize": {
                return this.minVSize != null && this.minVSize >= 0 ? "--min-vsize=" + this.minVSize + " " : "";
            }
        }
        throw new IllegalArgumentException("Unknown field: " + fieldName);
    }

    private String getCommandForStringField(String fieldName) {
        switch (fieldName) {
            case "debugger": {
                return this.debugger != null && !this.debugger.isEmpty() ? "--debugger=".concat(this.debugger).concat(" ") : "";
            }
            case "debuggerArgs": {
                return this.debuggerArgs != null && !this.debuggerArgs.isEmpty() ? "--debugger-args=".concat(this.debuggerArgs).concat(" ") : "";
            }
            case "gui": {
                return this.gui != null && !this.gui.isEmpty() ? "--gui=".concat(this.gui).concat(" ") : "";
            }
            case "arch": {
                return this.arch != null && !this.arch.isEmpty() ? "--arch=".concat(this.arch).concat(" ") : "";
            }
            case "args": {
                return this.args != null && !this.args.isEmpty() ? this.args : "";
            }
            case "file": {
                return this.file != null && !this.file.isEmpty() ? "--file=".concat(this.file).concat(" ") : "";
            }
        }
        throw new IllegalArgumentException("Unknown field: " + fieldName);
    }

    public void setSave(boolean save) {
        this.save = save;
    }

    public void setNoSave(boolean noSave) {
        this.noSave = noSave;
    }

    public void setNoEnviron(boolean noEnviron) {
        this.noEnviron = noEnviron;
    }

    public void setNoSiteFile(boolean noSiteFile) {
        this.noSiteFile = noSiteFile;
    }

    public void setNoInitFile(boolean noInitFile) {
        this.noInitFile = noInitFile;
    }

    public void setRestore(boolean restore) {
        this.restore = restore;
    }

    public void setNoRestoreData(boolean noRestoreData) {
        this.noRestoreData = noRestoreData;
    }

    public void setNoRestoreHistory(boolean noRestoreHistory) {
        this.noRestoreHistory = noRestoreHistory;
    }

    public void setNoRestore(boolean noRestore) {
        this.noRestore = noRestore;
    }

    public void setVanilla(boolean vanilla) {
        this.vanilla = vanilla;
    }

    public void setNoReadLine(boolean noReadLine) {
        this.noReadLine = noReadLine;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void setSlave(boolean slave) {
        this.slave = slave;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setMaxPPSize(Integer maxPPSize) {
        this.maxPPSize = maxPPSize;
    }

    public void setMinNSize(Integer minNSize) {
        this.minNSize = minNSize;
    }

    public void setMinVSize(Integer minVSize) {
        this.minVSize = minVSize;
    }

    public void setDebugger(String debugger) {
        this.debugger = debugger;
    }

    public void setGui(String gui) {
        this.gui = gui;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public void setFile(String file) {
        this.file = file;
    }
}

