/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller.rstuff;

import com.github.rcaller.EventHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

public class RStreamHandler
implements Runnable {
    private AtomicBoolean stillReading = new AtomicBoolean();
    private InputStream stream = null;
    private BufferedReader reader = null;
    private final Thread consumerThread;
    private String name = null;
    private ArrayList<EventHandler> eventHandlers = null;
    private boolean OKAYdetected = false;

    public RStreamHandler(InputStream stream, String name) {
        this.stream = stream;
        this.name = name;
        this.consumerThread = new Thread((Runnable)this, name + "ProcessorThread");
        this.eventHandlers = new ArrayList();
    }

    public boolean isOKAYdetected() {
        return this.OKAYdetected;
    }

    public void setOKAYdetected(boolean OKAYdetected) {
        this.OKAYdetected = OKAYdetected;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public void addEventHandler(EventHandler eh) {
        this.eventHandlers.add(eh);
    }

    public void removeEventHandler(EventHandler eh) {
        this.eventHandlers.remove(eh);
    }

    public void start() {
        this.consumerThread.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        try {
            do {
                this.stillReading.set(false);
                this.consumerThread.join(100L);
                if (!this.consumerThread.isAlive()) return;
            } while (this.stillReading.get());
            this.consumerThread.interrupt();
            return;
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isAlive() {
        return this.consumerThread.isAlive();
    }

    @Override
    public void run() {
        if (this.reader == null) {
            Charset charset = Charset.forName(System.getProperty("sun.jnu.encoding", Charset.defaultCharset().name()));
            this.reader = new BufferedReader(new InputStreamReader(this.stream, charset));
        }
        try {
            block2: while (true) {
                String s = this.reader.readLine();
                this.OKAYdetected = false;
                this.stillReading.set(true);
                if (s != null) {
                    if (s.contains("OKAY!")) {
                        this.OKAYdetected = true;
                    }
                    Iterator<EventHandler> iterator = this.eventHandlers.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        EventHandler eventHandler = iterator.next();
                        eventHandler.messageReceived(this.name, s);
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.stillReading.set(false);
    }
}

