/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller.scriptengine;

import com.github.rcaller.EventHandler;
import com.github.rcaller.rstuff.RCaller;
import com.github.rcaller.rstuff.RCode;
import com.github.rcaller.rstuff.ROutputParser;
import com.github.rcaller.scriptengine.NamedArgument;
import com.github.rcaller.scriptengine.RCallerScriptEngineFactory;
import com.github.rcaller.util.RCodeUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;

public class RCallerScriptEngine
implements ScriptEngine,
EventHandler,
Invocable {
    private final RCaller rcaller = RCaller.create();
    private final RCode rcode = RCode.create();
    private ROutputParser parser;
    private Bindings bindings;
    private ScriptContext context;

    public RCallerScriptEngine() {
        this.rcode.addRCode("result <- list(a=0)");
        this.rcaller.setRCode(this.rcode);
        this.rcaller.runAndReturnResultOnline("result");
        this.context = new SimpleScriptContext();
    }

    @Override
    public Object eval(String code, ScriptContext sc) throws ScriptException {
        return this.eval(code);
    }

    @Override
    public Object eval(Reader reader, ScriptContext sc) throws ScriptException {
        return this.eval(reader);
    }

    @Override
    public Object eval(String code) throws ScriptException {
        this.rcode.clearOnline();
        this.rcode.addRCode(code);
        this.rcode.addRCode("result <- list(a=0)");
        this.rcaller.setRCode(this.rcode);
        this.rcaller.runAndReturnResultOnline("result");
        return null;
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException ioe) {
            throw new ScriptException("Error while reading from reader: " + ioe.toString());
        }
        return this.eval(stringBuilder.toString());
    }

    @Override
    public Object eval(String code, Bindings bndngs) throws ScriptException {
        return this.eval(code);
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(reader);
    }

    @Override
    public void put(String name, Object o) {
        this.rcode.clearOnline();
        StringBuilder code = new StringBuilder();
        RCodeUtils.addRespectToType(code, name, o, false);
        this.rcode.addRCode("result <- list(a=0)");
        this.rcode.setCode(code);
        this.rcaller.setRCode(this.rcode);
        this.rcaller.runAndReturnResultOnline("result");
    }

    @Override
    public Object get(String var) {
        int[] dimension;
        this.rcode.clearOnline();
        this.rcode.addRCode("result <- ls()");
        this.rcaller.runAndReturnResultOnline(var);
        this.parser = this.rcaller.getParser();
        this.parser.parse();
        try {
            dimension = this.parser.getDimensions(var);
        }
        catch (Exception e) {
            return this.parser.getAsStringArray(var);
        }
        String vartype = this.parser.getType(var);
        if (dimension[0] > 1 && dimension[1] > 1) {
            return this.parser.getAsDoubleMatrix(var);
        }
        if (vartype.equals("numeric")) {
            return this.parser.getAsDoubleArray(var);
        }
        if (vartype.equals("character")) {
            return this.parser.getAsStringArray(var);
        }
        return this.parser.getAsStringArray(var);
    }

    @Override
    public Bindings getBindings(int i) {
        return this.bindings;
    }

    @Override
    public void setBindings(Bindings bndngs, int i) {
        this.bindings = bndngs;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext sc) {
        this.context = sc;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return new RCallerScriptEngineFactory();
    }

    @Override
    public void messageReceived(String senderName, String msg) {
        System.out.println("RCaller Script Engine Received: (" + senderName + ") " + msg);
    }

    public void close() {
        this.rcaller.stopRCallerOnline();
    }

    @Override
    public Object invokeMethod(Object o, String fname, Object ... arguments) throws ScriptException, NoSuchMethodException {
        return this.invokeFunction(fname, arguments);
    }

    @Override
    public Object invokeFunction(String fname, Object ... arguments) throws ScriptException, NoSuchMethodException {
        int[] dimension = null;
        String var = "fresult";
        this.rcode.clearOnline();
        this.rcode.addRCode(var + " <- " + fname + "(");
        for (int i = 0; i < arguments.length; ++i) {
            NamedArgument named = (NamedArgument)arguments[i];
            RCodeUtils.addRespectToType(this.rcode.getCode(), named.getName(), named.getObj(), true);
            if (i == arguments.length - 1) continue;
            this.rcode.addRCode(",");
        }
        this.rcode.addRCode(")");
        this.rcaller.setRCode(this.rcode);
        this.rcaller.runAndReturnResultOnline(var);
        this.parser = this.rcaller.getParser();
        ArrayList<NamedArgument> namedResults = new ArrayList<NamedArgument>();
        ArrayList<String> names = this.rcaller.getParser().getNames();
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name;
            var = name = iterator.next();
            try {
                dimension = this.parser.getDimensions(var);
            }
            catch (Exception e) {
                namedResults.add(NamedArgument.Named(var, this.parser.getAsStringArray(var)));
            }
            String vartype = this.parser.getType(var);
            assert (dimension != null);
            if (dimension[0] > 1 && dimension[1] > 1) {
                namedResults.add(NamedArgument.Named(var, this.parser.getAsDoubleMatrix(var)));
                continue;
            }
            if (vartype.equals("numeric")) {
                namedResults.add(NamedArgument.Named(var, this.parser.getAsDoubleArray(var)));
                continue;
            }
            if (vartype.equals("character")) {
                namedResults.add(NamedArgument.Named(var, this.parser.getAsStringArray(var)));
                continue;
            }
            namedResults.add(NamedArgument.Named(var, this.parser.getAsStringArray(var)));
        }
        return namedResults;
    }

    @Override
    public <T> T getInterface(Class<T> type) {
        return null;
    }

    @Override
    public <T> T getInterface(Object o, Class<T> type) {
        return null;
    }
}

