/*
 * Decompiled with CFR 0.152.
 */
package com.github.rcaller.util;

import com.github.rcaller.exception.ExecutionException;
import com.github.rcaller.graphics.DefaultTheme;
import com.github.rcaller.graphics.GraphicsTheme;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;

public class Globals {
    public static String cranRepos = "http://cran.r-project.org";
    public static String RScript_Windows = "C:\\Program Files\\R\\R-3.0.2\\bin\\Rscript.exe";
    public static String RScript_Linux = "/usr/bin/Rscript";
    public static String RScript_Mac = "/usr/local/bin/Rscript";
    public static String Rscript_current;
    public static String R_Windows;
    public static String R_Linux;
    public static String R_Mac;
    public static String R_current;
    public static Locale standardLocale;
    public static Charset standardCharset;
    public static GraphicsTheme theme;
    public static final String version = "RCaller 3.0";
    public static final String about = "Author: Mehmet Hakan Satman - mhsatman@yahoo.com";
    public static final String license = "LGPL v3.0";

    public static void detect_current_rscript() {
        if (Globals.isWindows()) {
            Rscript_current = RScript_Windows;
            R_current = R_Windows;
        } else if (Globals.isMac()) {
            Rscript_current = RScript_Mac;
            R_current = R_Mac;
        } else {
            Rscript_current = RScript_Linux;
            R_current = R_Linux;
        }
    }

    public static boolean isMac() {
        return System.getProperty("os.name").contains("Mac");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static File findFileRecursively(File startingPath, String filename) {
        if (!startingPath.isDirectory()) {
            throw new ExecutionException(startingPath.toString() + " is not a directory:");
        }
        File[] childs = startingPath.listFiles();
        if (childs != null && childs.length > 0) {
            for (File child : childs) {
                File subsearch;
                if (child.isFile()) {
                    if (!child.getName().equals(filename)) continue;
                    return child;
                }
                if (!child.isDirectory() || child.listFiles().length <= 0 || (subsearch = Globals.findFileRecursively(child, filename)) == null) continue;
                return subsearch;
            }
        }
        return null;
    }

    public static void setRscriptCurrent(String rscript_current) {
        Rscript_current = rscript_current;
        if (Globals.isWindows()) {
            RScript_Windows = rscript_current;
        } else if (Globals.isMac()) {
            RScript_Mac = rscript_current;
        } else {
            RScript_Linux = rscript_current;
        }
    }

    public static void setR_current(String r_current) {
        R_current = r_current;
        if (Globals.isWindows()) {
            R_Windows = R_current;
        }
        if (Globals.isMac()) {
            R_Mac = R_current;
        } else {
            R_Linux = r_current;
        }
    }

    public static void setRPaths(String rscript_current, String r_current) {
        Globals.setRscriptCurrent(rscript_current);
        Globals.setR_current(r_current);
    }

    public static String getSystemSpecificRPathParameter(File file) {
        String path = Globals.isWindows() ? file.getAbsolutePath().toString().replace("\\", "/") : file.getAbsolutePath().toString();
        return path;
    }

    public static void setChatset(Charset charset) {
        standardCharset = charset;
    }

    public static void setLocale(Locale locale) {
        standardLocale = locale;
    }

    static {
        R_Windows = "C:\\Program Files\\R\\R-3.0.2\\bin\\R.exe";
        R_Linux = "/usr/bin/R";
        R_Mac = "/usr/local/bin/R";
        standardLocale = Locale.getDefault();
        standardCharset = StandardCharsets.UTF_8;
        theme = new DefaultTheme();
        if (Globals.isWindows()) {
            File rBase;
            Object[] rVersions;
            String programFiles = System.getenv("ProgramFiles");
            if (programFiles == null) {
                programFiles = "C:\\Program Files";
            }
            if ((rVersions = (rBase = new File(programFiles, "R")).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().startsWith("R-");
                }
            })) != null) {
                File rBin64;
                Arrays.sort(rVersions);
                Object rHome = rVersions[rVersions.length - 1];
                File rBin = new File((File)rHome, "bin");
                if ("amd64".equals(System.getProperty("os.arch")) && (rBin64 = new File(rBin, "x64")).exists()) {
                    rBin = rBin64;
                }
                R_Windows = new File(rBin, "R.exe").getAbsolutePath();
                RScript_Windows = new File(rBin, "Rscript.exe").getAbsolutePath();
            }
        }
    }
}

