/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.github.rcaller.rstuff.RCaller;
import com.github.rcaller.rstuff.RCode;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DescriptiveStatistics {
    public DescriptiveStatistics() {
        try {
            Random random = new Random();
            RCaller caller = RCaller.create();
            RCode code = RCode.create();
            double[] data = new double[100];
            for (int i = 0; i < data.length; ++i) {
                data[i] = random.nextGaussian();
            }
            code.addDoubleArray("x", data);
            code.addRCode("my.mean<-mean(x)");
            code.addRCode("my.var<-var(x)");
            code.addRCode("my.sd<-sd(x)");
            code.addRCode("my.min<-min(x)");
            code.addRCode("my.max<-max(x)");
            code.addRCode("my.standardized<-scale(x)");
            code.addRCode("my.all<-list(mean=my.mean, variance=my.var, sd=my.sd, min=my.min, max=my.max, std=my.standardized)");
            caller.setRCode(code);
            caller.runAndReturnResult("my.all");
            double[] results = caller.getParser().getAsDoubleArray("mean");
            System.out.println("Mean is " + results[0]);
            results = caller.getParser().getAsDoubleArray("variance");
            System.out.println("Variance is " + results[0]);
            results = caller.getParser().getAsDoubleArray("sd");
            System.out.println("Standard deviation is " + results[0]);
            results = caller.getParser().getAsDoubleArray("min");
            System.out.println("Minimum is " + results[0]);
            results = caller.getParser().getAsDoubleArray("max");
            System.out.println("Maximum is " + results[0]);
            results = caller.getParser().getAsDoubleArray("std");
            System.out.println("Standardized x is ");
            for (double result : results) {
                System.out.print(result + ", ");
            }
        }
        catch (Exception e) {
            Logger.getLogger(DescriptiveStatistics.class.getName()).log(Level.SEVERE, e.getMessage());
        }
    }

    public static void main(String[] args) {
        new DescriptiveStatistics();
    }
}

