/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.github.rcaller.rstuff.RCaller;
import com.github.rcaller.rstuff.RCode;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OrdinaryLeastSquares {
    public static void main(String[] args) {
        new OrdinaryLeastSquares();
    }

    public OrdinaryLeastSquares() {
        try {
            int i;
            RCaller caller = RCaller.create();
            RCode code = RCode.create();
            double[] x = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
            double[] y = new double[]{2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 30.0};
            code.addDoubleArray("x", x);
            code.addDoubleArray("y", y);
            code.addRCode("ols<-lm(y~x)");
            caller.setRCode(code);
            caller.runAndReturnResult("ols");
            System.out.println("Available results from lm() object:");
            System.out.println(caller.getParser().getNames());
            double[] residuals = caller.getParser().getAsDoubleArray("residuals");
            double[] coefficients = caller.getParser().getAsDoubleArray("coefficients");
            double[] fitteds = caller.getParser().getAsDoubleArray("fitted_values");
            System.out.println("Coefficients:");
            for (i = 0; i < coefficients.length; ++i) {
                System.out.println("Beta " + i + " = " + coefficients[i]);
            }
            System.out.println("Residuals:");
            for (i = 0; i < residuals.length; ++i) {
                System.out.println(i + " = " + residuals[i]);
            }
            System.out.println("Fitted Values:");
            for (i = 0; i < fitteds.length; ++i) {
                System.out.println(i + " = " + fitteds[i]);
            }
        }
        catch (Exception e) {
            Logger.getLogger(OrdinaryLeastSquares.class.getName()).log(Level.SEVERE, e.getMessage());
        }
    }
}

