/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.github.rcaller.rstuff.RCaller;
import com.github.rcaller.rstuff.RCode;
import com.github.rcaller.util.Globals;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SampleGui
extends JFrame
implements ActionListener {
    private JTextArea textArea;
    private JButton button;
    private JTextField textField;
    private JTextArea textResult;
    private JTextArea inputStreamResult;
    private JTextArea errorStreamResult;

    public SampleGui() {
        super("RCaller Sample GUI");
        this.setDefaultCloseOperation(3);
        this.setSize(640, 480);
        this.setLayout(null);
        Globals.detect_current_rscript();
        this.textArea = new JTextArea("myvar<-c(1,2,3,4,5)\nothervar<-runif(10,0,1)\ncat(\"Hello World!\")\nfor(i in 1:5){\nprint(i)\n}\n");
        this.textArea.setSize(350, 200);
        this.textArea.setLocation(10, 20);
        this.textArea.setBorder(new TitledBorder("R Code"));
        this.add(this.textArea);
        this.inputStreamResult = new JTextArea();
        this.inputStreamResult.setSize(350, 70);
        this.inputStreamResult.setLocation(10, 230);
        this.inputStreamResult.setBorder(new TitledBorder("Output by R"));
        this.add(this.inputStreamResult);
        this.errorStreamResult = new JTextArea();
        this.errorStreamResult.setSize(350, 70);
        this.errorStreamResult.setLocation(10, 310);
        this.errorStreamResult.setBorder(new TitledBorder("Error by R"));
        this.add(this.errorStreamResult);
        this.textField = new JTextField("othervar");
        this.textField.setSize(200, 50);
        this.textField.setLocation(380, 20);
        this.textField.setBorder(new TitledBorder("Handle this by Java"));
        this.add(this.textField);
        this.button = new JButton("Run R Code");
        this.button.setSize(150, 40);
        this.button.setLocation(380, 90);
        this.button.addActionListener(this);
        this.add(this.button);
        this.textResult = new JTextArea();
        this.textResult.setSize(200, 250);
        this.textResult.setLocation(380, 140);
        this.textResult.setBorder(new TitledBorder("Result as Java object"));
        this.add(this.textResult);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new SampleGui();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Run R Code")) {
            this.inputStreamResult.setText("");
            this.errorStreamResult.setText("");
            RCaller caller = RCaller.create();
            RCode code = RCode.create();
            code.addRCode(this.textArea.getText());
            try {
                caller.setRCode(code);
                caller.runAndReturnResult(this.textField.getText());
                double[] result = caller.getParser().getAsDoubleArray(this.textField.getText());
                StringBuilder buf = new StringBuilder();
                for (double aResult : result) {
                    buf.append(aResult).append("\n");
                }
                this.textResult.setText(buf.toString());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.toString());
            }
        }
    }
}

