/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.github.rcaller.rstuff.RCaller;
import com.github.rcaller.rstuff.RCode;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnitRoots {
    public static void main(String[] args) {
        new UnitRoots();
    }

    public UnitRoots() {
        try {
            Random random = new Random(12345L);
            double[] stockClosePrices = new double[100];
            stockClosePrices[0] = 0.0;
            for (int i = 1; i < stockClosePrices.length; ++i) {
                stockClosePrices[i] = 0.5 + 1.0 * stockClosePrices[0] + random.nextGaussian();
            }
            RCaller caller = RCaller.create();
            RCode code = RCode.create();
            code.addDoubleArray("x", stockClosePrices);
            code.R_require("fUnitRoots");
            code.addRCode("ww <- diff(x, differences = 1)");
            code.addRCode("tt <- unitrootTest(ww, lags=0)");
            caller.setRCode(code);
            caller.runAndReturnResult("tt@test");
            double[] res = caller.getParser().getAsDoubleArray("statistic");
            System.out.println(res[0]);
            System.out.println("success");
        }
        catch (Exception e) {
            Logger.getLogger(UnitRoots.class.getName()).log(Level.SEVERE, e.getMessage());
        }
    }
}

