/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVRecordProcessor;
import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.MetaCSVRecord;
import com.github.jferard.javamcsv.ProcessorProvider;
import com.github.jferard.javamcsv.TextFieldDescription;
import java.util.Iterator;
import org.apache.commons.csv.CSVRecord;

public class CSVRecordIterator
implements Iterator<MetaCSVRecord> {
    public static final FieldProcessor<String> TEXT_PROCESSOR = TextFieldDescription.INSTANCE.toFieldProcessor(null);
    public static CSVRecordProcessor HEADER_PROCESSOR = new CSVRecordProcessor(new ProcessorProvider(){

        @Override
        public FieldProcessor<?> getProcessor(int c) {
            return TEXT_PROCESSOR;
        }
    });
    private final Iterator<CSVRecord> csvIterator;
    private final CSVRecordProcessor processor;
    private boolean first;

    public CSVRecordIterator(Iterator<CSVRecord> csvIterator, CSVRecordProcessor processor) {
        this.csvIterator = csvIterator;
        this.processor = processor;
        this.first = true;
    }

    @Override
    public boolean hasNext() {
        return this.csvIterator.hasNext();
    }

    @Override
    public MetaCSVRecord next() {
        CSVRecord record = this.csvIterator.next();
        try {
            if (this.first) {
                this.first = false;
                return HEADER_PROCESSOR.process(record);
            }
            return this.processor.process(record);
        }
        catch (MetaCSVReadException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

