/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CurrencyIntegerFieldProcessor;
import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.FieldDescription;
import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.IntegerFieldDescription;
import com.github.jferard.javamcsv.Util;
import java.io.IOException;

public class CurrencyIntegerFieldDescription
implements FieldDescription<Long> {
    public static final FieldDescription<?> INSTANCE = new CurrencyIntegerFieldDescription(true, "$", IntegerFieldDescription.INSTANCE);
    private final boolean pre;
    private final String symbol;
    private final FieldDescription<Long> numberDescription;
    private final String nullValue;

    public CurrencyIntegerFieldDescription(boolean pre, String symbol, FieldDescription<Long> numberDescription) {
        this.pre = pre;
        this.symbol = symbol;
        this.numberDescription = numberDescription;
        this.nullValue = "";
    }

    @Override
    public void render(Appendable out) throws IOException {
        Util.render(out, "currency", this.pre ? "pre" : "post", this.symbol);
        out.append('/');
        this.numberDescription.render(out);
    }

    @Override
    public FieldProcessor<Long> toFieldProcessor(String nullValue) {
        return new CurrencyIntegerFieldProcessor(this.pre, this.symbol, this.numberDescription.toFieldProcessor(nullValue), nullValue);
    }

    @Override
    public Class<Long> getJavaType() {
        return Long.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.CURRENCY_INTEGER;
    }

    public String toString() {
        return String.format("CurrencyFieldDescription(%b, %s, %s)", this.pre, this.symbol, this.numberDescription.toString());
    }

    public String getCurrencySymbol() {
        return this.symbol;
    }
}

