/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.FieldProcessor;
import com.github.jferard.javamcsv.MetaCSVReadException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFieldProcessor
implements FieldProcessor<Date> {
    private final SimpleDateFormat simpleDateFormat;
    private final String locale;
    private final String nullValue;

    public DateFieldProcessor(SimpleDateFormat simpleDateFormat, String locale, String nullValue) {
        this.simpleDateFormat = simpleDateFormat;
        this.locale = locale;
        this.nullValue = nullValue;
    }

    @Override
    public Date toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        try {
            return this.simpleDateFormat.parse(text);
        }
        catch (ParseException e) {
            throw new MetaCSVReadException(e);
        }
    }

    @Override
    public String toString(Date date) {
        if (date == null) {
            return this.nullValue;
        }
        return this.simpleDateFormat.format(date);
    }
}

