/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.BooleanFieldDescription;
import com.github.jferard.javamcsv.CurrencyDecimalFieldDescription;
import com.github.jferard.javamcsv.CurrencyIntegerFieldDescription;
import com.github.jferard.javamcsv.DateFieldDescription;
import com.github.jferard.javamcsv.DatetimeFieldDescription;
import com.github.jferard.javamcsv.DecimalFieldDescription;
import com.github.jferard.javamcsv.FieldDescription;
import com.github.jferard.javamcsv.FloatFieldDescription;
import com.github.jferard.javamcsv.IntegerFieldDescription;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVDataBuilder;
import com.github.jferard.javamcsv.MetaCSVDataException;
import com.github.jferard.javamcsv.MetaCSVParseException;
import com.github.jferard.javamcsv.ObjectFieldDescription;
import com.github.jferard.javamcsv.PercentageDecimalFieldDescription;
import com.github.jferard.javamcsv.PercentageFloatFieldDescription;
import com.github.jferard.javamcsv.TextFieldDescription;
import com.github.jferard.javamcsv.Util;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class MetaCSVParser
implements Closeable {
    private final MetaCSVDataBuilder metaCSVDataBuilder;
    private final CSVParser parser;

    public static MetaCSVParser create(InputStream is) throws IOException {
        InputStreamReader reader = new InputStreamReader(is);
        return MetaCSVParser.create(reader);
    }

    public static MetaCSVParser create(Reader reader) throws IOException {
        CSVParser parser = new CSVParser(reader, CSVFormat.DEFAULT);
        return new MetaCSVParser(parser);
    }

    public MetaCSVParser(CSVParser parser) {
        this.parser = parser;
        this.metaCSVDataBuilder = new MetaCSVDataBuilder();
    }

    public MetaCSVData parse() throws MetaCSVParseException, MetaCSVDataException {
        Iterator it = this.parser.iterator();
        this.checkHeader(it);
        while (it.hasNext()) {
            CSVRecord record = (CSVRecord)it.next();
            String domain = record.get(0);
            String key = record.get(1);
            String value = record.get(2);
            this.parseRow(domain, key, value);
        }
        return this.metaCSVDataBuilder.build();
    }

    private void checkHeader(Iterator<CSVRecord> it) throws MetaCSVParseException {
        if (!it.hasNext()) {
            throw new MetaCSVParseException("Empty file");
        }
        CSVRecord header = it.next();
        if (!(header.get(0).equals("domain") && header.get(1).equals("key") && header.get(2).equals("value"))) {
            throw new MetaCSVParseException("Bad header: " + header.toString());
        }
    }

    private void parseRow(String domain, String key, String value) throws MetaCSVParseException {
        if (domain.equals("meta")) {
            this.parseMetaRow(key, value);
        } else if (domain.equals("file")) {
            this.parseFileRow(key, value);
        } else if (domain.equals("csv")) {
            this.parseCSVRow(key, value);
        } else if (domain.equals("data")) {
            this.parseDataRow(key, value);
        } else {
            throw new MetaCSVParseException("Unknown domain: " + domain);
        }
    }

    private void parseMetaRow(String key, String value) throws MetaCSVParseException {
        if (key.equals("version")) {
            this.metaCSVDataBuilder.metaVersion(value);
        } else {
            this.metaCSVDataBuilder.meta(key, value);
        }
    }

    private void parseFileRow(String key, String value) throws MetaCSVParseException {
        if (key.equals("encoding")) {
            this.metaCSVDataBuilder.encoding(value);
        } else if (key.equals("bom")) {
            this.metaCSVDataBuilder.bom(this.parseBoolean(value));
        } else if (key.equals("line_terminator")) {
            this.metaCSVDataBuilder.lineTerminator(value);
        } else {
            throw new MetaCSVParseException("Unknown key for domain `file`: " + key);
        }
    }

    private void parseCSVRow(String key, String value) throws MetaCSVParseException {
        if (key.equals("delimiter")) {
            this.metaCSVDataBuilder.delimiter(this.parseOneChar(value));
        } else if (key.equals("double_quote")) {
            this.metaCSVDataBuilder.doubleQuote(this.parseBoolean(value));
        } else if (key.equals("escape_char")) {
            this.metaCSVDataBuilder.escapeChar(this.parseOneChar(value));
        } else if (key.equals("quote_char")) {
            this.metaCSVDataBuilder.quoteChar(this.parseOneChar(value));
        } else if (key.equals("skip_initial_space")) {
            this.metaCSVDataBuilder.skipInitialSpace(this.parseBoolean(value));
        } else {
            throw new MetaCSVParseException("Expected csv key, got: " + value);
        }
    }

    private boolean parseBoolean(String value) throws MetaCSVParseException {
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new MetaCSVParseException("Expected boolean, got: " + value);
    }

    private char parseOneChar(String value) throws MetaCSVParseException {
        if (value.length() != 1) {
            throw new MetaCSVParseException("Expected one char, got: " + value);
        }
        return value.charAt(0);
    }

    private void parseDataRow(String key, String value) throws MetaCSVParseException {
        List<String> keys = Util.parse(key);
        if (keys.get(0).equals("col")) {
            if (keys.size() != 3) {
                throw new MetaCSVParseException("Unknown data key: " + keys);
            }
            this.parseDataColRow(keys.get(1), keys.get(2), value);
        } else if (keys.get(0).equals("null_value")) {
            if (keys.size() != 1) {
                throw new MetaCSVParseException("Unknown data key: " + keys);
            }
            this.metaCSVDataBuilder.nullValue(value);
        } else {
            throw new MetaCSVParseException("Unknown data key: " + key);
        }
    }

    private void parseDataColRow(String colNum, String colKey, String value) throws MetaCSVParseException {
        int c;
        try {
            c = Integer.parseInt(colNum);
        }
        catch (NumberFormatException e) {
            throw new MetaCSVParseException("Unknown col num: " + colNum);
        }
        this.parseDataColRow(c, colKey, value);
    }

    private void parseDataColRow(int c, String colKey, String value) throws MetaCSVParseException {
        if (!colKey.equals("type")) {
            throw new MetaCSVParseException("Unknown col n key: " + colKey);
        }
        this.parseColType(c, value);
    }

    private void parseColType(int c, String value) throws MetaCSVParseException {
        ObjectFieldDescription fieldDescription;
        List<String> values = Util.parse(value);
        String valueType = values.get(0);
        List<String> parameters = values.subList(1, values.size());
        if (valueType.equals("boolean")) {
            fieldDescription = this.parseBoolean(parameters);
        } else if (valueType.equals("currency")) {
            fieldDescription = this.parseCurrency(parameters);
        } else if (valueType.equals("date")) {
            fieldDescription = this.parseDate(parameters);
        } else if (valueType.equals("datetime")) {
            fieldDescription = this.parseDatetime(parameters);
        } else if (valueType.equals("decimal")) {
            fieldDescription = this.parseDecimal(parameters);
        } else if (valueType.equals("float")) {
            fieldDescription = this.parseFloat(parameters);
        } else if (valueType.equals("integer")) {
            fieldDescription = this.parseInteger(parameters);
        } else if (valueType.equals("percentage")) {
            fieldDescription = this.parsePercentage(parameters);
        } else if (valueType.equals("text")) {
            fieldDescription = TextFieldDescription.INSTANCE;
        } else if (valueType.equals("object")) {
            fieldDescription = new ObjectFieldDescription(parameters);
        } else {
            throw new MetaCSVParseException("Unknown col n type: " + valueType);
        }
        this.metaCSVDataBuilder.colType(c, fieldDescription);
    }

    private FieldDescription<Boolean> parseBoolean(List<String> parameters) throws MetaCSVParseException {
        String falseWord;
        String trueWord;
        if (parameters.size() == 1) {
            trueWord = parameters.get(0);
            falseWord = "";
        } else if (parameters.size() == 2) {
            trueWord = parameters.get(0);
            falseWord = parameters.get(1);
        } else {
            throw new MetaCSVParseException("Bad boolean format! " + parameters);
        }
        return new BooleanFieldDescription(trueWord, falseWord);
    }

    private FieldDescription<? extends Number> parseCurrency(List<String> parameters) throws MetaCSVParseException {
        boolean pre = this.parsePre(parameters.get(0));
        String symbol = parameters.get(1);
        String numberType = parameters.get(2);
        if (numberType.equals("integer")) {
            FieldDescription<Long> numberDescription = this.parseInteger(parameters.subList(3, parameters.size()));
            return new CurrencyIntegerFieldDescription(pre, symbol, numberDescription);
        }
        if (numberType.equals("decimal")) {
            FieldDescription<BigDecimal> numberDescription = this.parseDecimal(parameters.subList(3, parameters.size()));
            return new CurrencyDecimalFieldDescription(pre, symbol, numberDescription);
        }
        throw new MetaCSVParseException("Unknown currency number type: " + parameters);
    }

    private FieldDescription<Date> parseDate(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 1) {
            String format = parameters.get(0);
            return DateFieldDescription.create(format);
        }
        if (parameters.size() == 2) {
            String format = parameters.get(0);
            String locale = parameters.get(1);
            return DateFieldDescription.create(format, locale);
        }
        throw new MetaCSVParseException("Unknown date field: " + parameters);
    }

    private FieldDescription<Date> parseDatetime(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 1) {
            String format = parameters.get(0);
            return DatetimeFieldDescription.create(format);
        }
        if (parameters.size() == 2) {
            String format = parameters.get(0);
            String locale = parameters.get(1);
            return DatetimeFieldDescription.create(format, locale);
        }
        throw new MetaCSVParseException("Unknown datetime field: " + parameters);
    }

    private FieldDescription<Double> parseFloat(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 2) {
            return new FloatFieldDescription(parameters.get(0), parameters.get(1));
        }
        throw new MetaCSVParseException("Unknown integer field: " + parameters);
    }

    private FieldDescription<BigDecimal> parseDecimal(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 2) {
            return new DecimalFieldDescription(parameters.get(0), parameters.get(1));
        }
        throw new MetaCSVParseException("Unknown integer field: " + parameters);
    }

    private FieldDescription<Long> parseInteger(List<String> parameters) throws MetaCSVParseException {
        if (parameters.size() == 0) {
            return IntegerFieldDescription.INSTANCE;
        }
        if (parameters.size() == 1) {
            return new IntegerFieldDescription(parameters.get(0));
        }
        throw new MetaCSVParseException("Unknown integer field: " + parameters);
    }

    private boolean parsePre(String prePost) throws MetaCSVParseException {
        if (prePost.equals("pre")) {
            return true;
        }
        if (prePost.equals("post")) {
            return false;
        }
        throw new MetaCSVParseException("Unknown pre/post: " + prePost);
    }

    private FieldDescription<? extends Number> parsePercentage(List<String> parameters) throws MetaCSVParseException {
        boolean pre = this.parsePre(parameters.get(0));
        String symbol = parameters.get(1);
        String numberType = parameters.get(2);
        if (numberType.equals("float")) {
            FieldDescription<Double> numberDescription = this.parseFloat(parameters.subList(3, parameters.size()));
            return new PercentageFloatFieldDescription(pre, symbol, numberDescription);
        }
        if (numberType.equals("decimal")) {
            FieldDescription<BigDecimal> numberDescription = this.parseDecimal(parameters.subList(3, parameters.size()));
            return new PercentageDecimalFieldDescription(pre, symbol, numberDescription);
        }
        throw new MetaCSVParseException("Unknown currency number type: " + parameters);
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }
}

