/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVRecordIterator;
import com.github.jferard.javamcsv.CSVRecordProcessor;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVDataException;
import com.github.jferard.javamcsv.MetaCSVMetaData;
import com.github.jferard.javamcsv.MetaCSVParseException;
import com.github.jferard.javamcsv.MetaCSVParser;
import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.MetaCSVReaderFactory;
import com.github.jferard.javamcsv.MetaCSVRecord;
import com.github.jferard.javamcsv.Util;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.csv.CSVParser;

public class MetaCSVReader
implements Iterable<MetaCSVRecord>,
Closeable {
    private final CSVParser parser;
    private final CSVRecordProcessor processor;
    private MetaCSVMetaData metaData;

    public static MetaCSVReader create(File csvFile) throws IOException, MetaCSVParseException, MetaCSVReadException, MetaCSVDataException {
        File metaCSVFile = Util.withExtension(csvFile, ".mcsv");
        return MetaCSVReader.create(csvFile, metaCSVFile);
    }

    public static MetaCSVReader create(File csvFile, File metaCSVFile) throws IOException, MetaCSVParseException, MetaCSVReadException, MetaCSVDataException {
        FileInputStream metaIn = new FileInputStream(metaCSVFile);
        FileInputStream in = new FileInputStream(csvFile);
        return MetaCSVReader.create((InputStream)in, metaIn);
    }

    public static MetaCSVReader create(File csvFile, String ... metaCSVdirectives) throws IOException, MetaCSVParseException, MetaCSVReadException, MetaCSVDataException {
        FileInputStream in = new FileInputStream(csvFile);
        return MetaCSVReader.create((InputStream)in, metaCSVdirectives);
    }

    public static MetaCSVReader create(InputStream in, String ... metaCSVdirectives) throws IOException, MetaCSVParseException, MetaCSVDataException, MetaCSVReadException {
        String metaString = Util.join(metaCSVdirectives, "\r\n");
        StringReader metaReader = new StringReader("domain,key,value\r\n" + metaString);
        MetaCSVParser parser = MetaCSVParser.create(metaReader);
        return MetaCSVReader.create(in, parser);
    }

    public static MetaCSVReader create(InputStream in, InputStream metaIn) throws IOException, MetaCSVParseException, MetaCSVReadException, MetaCSVDataException {
        MetaCSVParser parser = MetaCSVParser.create(metaIn);
        return MetaCSVReader.create(in, parser);
    }

    private static MetaCSVReader create(InputStream in, MetaCSVParser parser) throws MetaCSVParseException, MetaCSVDataException, IOException, MetaCSVReadException {
        MetaCSVData data = parser.parse();
        if (data.isUtf8BOM()) {
            byte[] buffer = new byte[3];
            int count = 0;
            while (count < 3) {
                count = in.read(buffer, count, 3 - count);
            }
            if ((buffer[0] & 0xFF) != 239 || (buffer[1] & 0xFF) != 187 || (buffer[2] & 0xFF) != 191) {
                throw new MetaCSVReadException("BOM expected");
            }
        }
        InputStreamReader reader = new InputStreamReader(in, data.getEncoding());
        return new MetaCSVReaderFactory(data, reader).build();
    }

    public MetaCSVReader(CSVParser parser, CSVRecordProcessor processor, MetaCSVMetaData metaData) {
        this.parser = parser;
        this.processor = processor;
        this.metaData = metaData;
    }

    @Override
    public Iterator<MetaCSVRecord> iterator() {
        return new CSVRecordIterator(this.parser.iterator(), this.processor);
    }

    public long getRow() {
        return this.parser.getRecordNumber() - 1L;
    }

    public MetaCSVMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }
}

