/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.FieldDescription;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.TextFieldDescription;
import com.github.jferard.javamcsv.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MetaCSVRenderer {
    private final CSVPrinter printer;
    private final boolean minimal;

    public static MetaCSVRenderer create(OutputStream os) throws IOException {
        return MetaCSVRenderer.create(os, true);
    }

    public static MetaCSVRenderer create(OutputStream os, boolean minimal) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(os, Util.UTF_8_CHARSET);
        CSVPrinter printer = new CSVPrinter((Appendable)outWriter, CSVFormat.DEFAULT);
        return new MetaCSVRenderer(printer, minimal);
    }

    public MetaCSVRenderer(CSVPrinter printer, boolean minimal) {
        this.printer = printer;
        this.minimal = minimal;
    }

    public void render(MetaCSVData data) throws IOException {
        this.printer.printRecord(new Object[]{"domain", "key", "value"});
        if (this.minimal) {
            this.renderMinimal(data);
        } else {
            this.renderVerbose(data);
        }
        this.printer.flush();
    }

    private void renderMinimal(MetaCSVData data) throws IOException {
        String nullValue;
        char quoteChar;
        char delimiter;
        String lineTerminator;
        Charset encoding = data.getEncoding();
        if (encoding != Util.UTF_8_CHARSET) {
            this.printer.printRecord(new Object[]{"file", "encoding", encoding.toString()});
        }
        if (data.isUtf8BOM()) {
            this.printer.printRecord(new Object[]{"file", "bom", true});
        }
        if (!(lineTerminator = data.getLineTerminator()).equals("\r\n")) {
            this.printer.printRecord(new Object[]{"file", "line_terminator", Util.escapeLineTerminator(lineTerminator)});
        }
        if ((delimiter = data.getDelimiter()) != ',') {
            this.printer.printRecord(new Object[]{"csv", "delimiter", Character.valueOf(delimiter)});
        }
        if (!data.isDoubleQuote()) {
            this.printer.printRecord(new Object[]{"csv", "double_quote", "false"});
            this.printer.printRecord(new Object[]{"csv", "escape_char", Character.valueOf(data.getEscapeChar())});
        }
        if ((quoteChar = data.getQuoteChar()) != '\"') {
            this.printer.printRecord(new Object[]{"csv", "quote_char", Character.valueOf(quoteChar)});
        }
        if (data.isSkipInitialSpace()) {
            this.printer.printRecord(new Object[]{"csv", "skip_initial_space", "true"});
        }
        if ((nullValue = data.getNullValue()) != null && !nullValue.isEmpty()) {
            this.printer.printRecord(new Object[]{"data", "null_value", nullValue});
        }
        for (int i : data.getSortedColIndices()) {
            FieldDescription<?> description = data.getDescription(i);
            if (description instanceof TextFieldDescription) continue;
            StringBuilder out = new StringBuilder();
            description.render(out);
            this.printer.printRecord(new Object[]{"data", "col/" + i + "/type", out.toString()});
        }
    }

    private void renderVerbose(MetaCSVData data) throws IOException {
        this.printer.printRecord(new Object[]{"file", "encoding", data.getEncoding().toString()});
        this.printer.printRecord(new Object[]{"file", "bom", data.isUtf8BOM()});
        this.printer.printRecord(new Object[]{"file", "line_terminator", Util.escapeLineTerminator(data.getLineTerminator())});
        this.printer.printRecord(new Object[]{"csv", "delimiter", Character.valueOf(data.getDelimiter())});
        boolean doubleQuote = data.isDoubleQuote();
        this.printer.printRecord(new Object[]{"csv", "double_quote", doubleQuote});
        if (!doubleQuote) {
            this.printer.printRecord(new Object[]{"csv", "escape_char", Character.valueOf(data.getEscapeChar())});
        }
        this.printer.printRecord(new Object[]{"csv", "quote_char", Character.valueOf(data.getQuoteChar())});
        this.printer.printRecord(new Object[]{"csv", "skip_initial_space", data.isSkipInitialSpace()});
        this.printer.printRecord(new Object[]{"data", "null_value", data.getNullValue()});
        for (int i : data.getSortedColIndices()) {
            FieldDescription<?> description = data.getDescription(i);
            StringBuilder out = new StringBuilder();
            description.render(out);
            this.printer.printRecord(new Object[]{"data", "col/" + i + "/type", out.toString()});
        }
    }
}

