/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.MetaCSVRecord;
import com.github.jferard.javamcsv.OnError;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.TextFieldDescription;
import com.github.jferard.javamcsv.processor.CSVRecordProcessor;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import com.github.jferard.javamcsv.processor.FieldProcessorFactory;
import com.github.jferard.javamcsv.processor.ProcessorProvider;
import com.github.jferard.javamcsv.processor.ReadFieldProcessor;
import com.github.jferard.javamcsv.processor.ReadProcessorProvider;
import java.util.Iterator;
import org.apache.commons.csv.CSVRecord;

public class CSVRecordsIterator
implements Iterator<MetaCSVRecord> {
    public static final FieldProcessor<String> TEXT_PROCESSOR = TextFieldDescription.INSTANCE.toFieldProcessor(null);
    public static final ReadFieldProcessor<?> SAFE_TEXT_PROCESSOR = new FieldProcessorFactory().toReadFieldProcessor(TextFieldDescription.INSTANCE, null, OnError.EXCEPTION);
    public static CSVRecordProcessor HEADER_PROCESSOR = new CSVRecordProcessor(new ProcessorProvider(null, null){

        @Override
        public FieldProcessor<?> getProcessor(int c) {
            return TEXT_PROCESSOR;
        }
    }, new ReadProcessorProvider(null, null, null){

        @Override
        public ReadFieldProcessor<?> getProcessor(int c) {
            return SAFE_TEXT_PROCESSOR;
        }
    }, OnError.TEXT, Util.UTC_TIME_ZONE);
    private final Iterator<CSVRecord> csvIterator;
    private final CSVRecordProcessor processor;
    private boolean first;

    public CSVRecordsIterator(Iterator<CSVRecord> csvIterator, CSVRecordProcessor processor) {
        this.csvIterator = csvIterator;
        this.processor = processor;
        this.first = true;
    }

    @Override
    public boolean hasNext() {
        return this.csvIterator.hasNext();
    }

    @Override
    public MetaCSVRecord next() {
        CSVRecord record = this.csvIterator.next();
        if (this.first) {
            this.first = false;
            return HEADER_PROCESSOR.createRecord(record);
        }
        return this.processor.createRecord(record);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

