/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.ColTypeParser;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVDataBuilder;
import com.github.jferard.javamcsv.MetaCSVDataException;
import com.github.jferard.javamcsv.MetaCSVParseException;
import com.github.jferard.javamcsv.MetaCSVParserBuilder;
import com.github.jferard.javamcsv.MetaCSVRow;
import com.github.jferard.javamcsv.ObjectTypeParser;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.FieldDescription;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;

public class MetaCSVParser
implements Closeable {
    private final MetaCSVDataBuilder metaCSVDataBuilder;
    private final Iterable<? extends Iterable<String>> rows;
    private boolean header;
    private ColTypeParser colTypeParser;

    public static MetaCSVParser create(InputStream metaIn) throws IOException {
        return MetaCSVParser.create(metaIn, true);
    }

    public static MetaCSVParser create(InputStream metaIn, boolean header) throws IOException {
        InputStreamReader reader = new InputStreamReader(metaIn);
        return MetaCSVParser.create(reader, header);
    }

    public static MetaCSVParser create(Reader reader) throws IOException {
        return MetaCSVParser.create(reader, true);
    }

    public static MetaCSVParser create(Reader reader, boolean header) throws IOException {
        CSVParser parser = new CSVParser(reader, CSVFormat.DEFAULT);
        return new MetaCSVParser((Iterable<? extends Iterable<String>>)parser, header, MetaCSVParserBuilder.DEFAULT_OBJECT_PARSER);
    }

    public static MetaCSVParser create(Iterable<? extends Iterable<String>> metaTriplets, boolean header) {
        return new MetaCSVParser(metaTriplets, header, MetaCSVParserBuilder.DEFAULT_OBJECT_PARSER);
    }

    public MetaCSVParser(Iterable<? extends Iterable<String>> rows, boolean header, ObjectTypeParser objectParser) {
        this.rows = rows;
        this.header = header;
        this.metaCSVDataBuilder = new MetaCSVDataBuilder();
        this.colTypeParser = new ColTypeParser(objectParser);
    }

    public MetaCSVData parse() throws MetaCSVParseException, MetaCSVDataException {
        Iterator<? extends Iterable<String>> it = this.rows.iterator();
        if (this.header) {
            this.checkHeader(it);
        }
        while (it.hasNext()) {
            MetaCSVRow row = MetaCSVRow.fromIterable(it.next());
            this.parseRow(row.getDomain(), row.getKey(), row.getValue());
        }
        return this.metaCSVDataBuilder.build();
    }

    private void checkHeader(Iterator<? extends Iterable<String>> it) throws MetaCSVParseException {
        if (!it.hasNext()) {
            throw new MetaCSVParseException("Empty file");
        }
        MetaCSVRow header = MetaCSVRow.fromIterable(it.next());
        if (!(header.getDomain().equals("domain") && header.getKey().equals("key") && header.getValue().equals("value"))) {
            throw new MetaCSVParseException("Bad header: " + header.toString());
        }
    }

    private void parseRow(String domain, String key, String value) throws MetaCSVParseException {
        if (domain.equals("meta")) {
            this.parseMetaRow(key, value);
        } else if (domain.equals("file")) {
            this.parseFileRow(key, value);
        } else if (domain.equals("csv")) {
            this.parseCSVRow(key, value);
        } else if (domain.equals("data")) {
            this.parseDataRow(key, value);
        } else {
            throw new MetaCSVParseException("Unknown domain: " + domain);
        }
    }

    private void parseMetaRow(String key, String value) {
        if (key.equals("version")) {
            this.metaCSVDataBuilder.metaVersion(value);
        } else {
            this.metaCSVDataBuilder.meta(key, value);
        }
    }

    private void parseFileRow(String key, String value) throws MetaCSVParseException {
        if (key.equals("encoding")) {
            this.metaCSVDataBuilder.encoding(value);
        } else if (key.equals("bom")) {
            this.metaCSVDataBuilder.bom(this.parseBoolean(value));
        } else if (key.equals("line_terminator")) {
            this.metaCSVDataBuilder.lineTerminator(value);
        } else {
            throw new MetaCSVParseException("Unknown key for domain `file`: " + key);
        }
    }

    private void parseCSVRow(String key, String value) throws MetaCSVParseException {
        if (key.equals("delimiter")) {
            this.metaCSVDataBuilder.delimiter(this.parseOneChar(value));
        } else if (key.equals("double_quote")) {
            this.metaCSVDataBuilder.doubleQuote(this.parseBoolean(value));
        } else if (key.equals("escape_char")) {
            this.metaCSVDataBuilder.escapeChar(this.parseOneChar(value));
        } else if (key.equals("quote_char")) {
            this.metaCSVDataBuilder.quoteChar(this.parseOneChar(value));
        } else if (key.equals("skip_initial_space")) {
            this.metaCSVDataBuilder.skipInitialSpace(this.parseBoolean(value));
        } else {
            throw new MetaCSVParseException("Expected csv key, got: " + value);
        }
    }

    private boolean parseBoolean(String value) throws MetaCSVParseException {
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new MetaCSVParseException("Expected boolean, got: " + value);
    }

    private char parseOneChar(String value) throws MetaCSVParseException {
        if (value.length() != 1) {
            throw new MetaCSVParseException("Expected one char, got: " + value);
        }
        return value.charAt(0);
    }

    private void parseDataRow(String key, String value) throws MetaCSVParseException {
        List<String> keys = Util.parse(key);
        if (keys.get(0).equals("col")) {
            if (keys.size() != 3) {
                throw new MetaCSVParseException("Unknown data key: " + keys);
            }
            this.parseDataColRow(keys.get(1), keys.get(2), value);
        } else if (keys.get(0).equals("null_value")) {
            if (keys.size() != 1) {
                throw new MetaCSVParseException("Unknown data key: " + keys);
            }
            this.metaCSVDataBuilder.nullValue(value);
        } else {
            throw new MetaCSVParseException("Unknown data key: " + key);
        }
    }

    private void parseDataColRow(String colNum, String colKey, String value) throws MetaCSVParseException {
        int c;
        try {
            c = Integer.parseInt(colNum);
        }
        catch (NumberFormatException e) {
            throw new MetaCSVParseException("Unknown col num: " + colNum);
        }
        this.parseDataColRow(c, colKey, value);
    }

    private void parseDataColRow(int c, String colKey, String value) throws MetaCSVParseException {
        if (!colKey.equals("type")) {
            throw new MetaCSVParseException("Unknown col n key: " + colKey);
        }
        this.parseColType(c, value);
    }

    private void parseColType(int c, String value) throws MetaCSVParseException {
        FieldDescription<?> fieldDescription = this.colTypeParser.parseColType(value);
        this.metaCSVDataBuilder.colType(c, fieldDescription);
    }

    @Override
    public void close() throws IOException {
        if (this.rows instanceof Closeable) {
            ((Closeable)((Object)this.rows)).close();
        }
    }
}

