/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVDataException;
import com.github.jferard.javamcsv.MetaCSVParseException;
import com.github.jferard.javamcsv.MetaCSVParser;
import com.github.jferard.javamcsv.ObjectTypeParser;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.description.ObjectFieldDescription;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;

public class MetaCSVParserBuilder {
    public static final ObjectTypeParser DEFAULT_OBJECT_PARSER = new ObjectTypeParser(){

        @Override
        public FieldDescription<?> parse(List<String> parameters) {
            return new ObjectFieldDescription(parameters);
        }
    };
    private File metaCSVFile;
    private String[] metaCSVDirectives;
    private Iterable<? extends Iterable<String>> metaTriplets;
    private InputStream metaIn;
    private MetaCSVParser metaParser;
    private boolean header;
    private ObjectTypeParser objectParser = DEFAULT_OBJECT_PARSER;

    public MetaCSVParserBuilder metaCSVFile(File metaCSVFile) {
        this.metaCSVFile = metaCSVFile;
        this.header = true;
        return this;
    }

    public MetaCSVParserBuilder metaCSVDirectives(String ... metaCSVDirectives) {
        this.metaCSVDirectives = metaCSVDirectives;
        this.header = false;
        return this;
    }

    public MetaCSVParserBuilder metaTriplets(Iterable<? extends Iterable<String>> metaTriplets) {
        this.metaTriplets = metaTriplets;
        this.header = false;
        return this;
    }

    public MetaCSVParserBuilder header(boolean header) {
        this.header = header;
        return this;
    }

    public MetaCSVParserBuilder metaIn(InputStream metaIn) {
        this.metaIn = metaIn;
        this.header = true;
        return this;
    }

    public MetaCSVParserBuilder metaParser(MetaCSVParser metaParser) {
        this.metaParser = metaParser;
        this.header = true;
        return this;
    }

    public MetaCSVParserBuilder objectParser(ObjectTypeParser objectParser) {
        this.objectParser = objectParser;
        return this;
    }

    public MetaCSVData buildData() throws MetaCSVDataException, MetaCSVParseException, IOException {
        return this.build().parse();
    }

    public MetaCSVParser build() throws MetaCSVParseException, IOException {
        if (this.metaParser == null) {
            Iterable<? extends Iterable<String>> rows = this.buildRows();
            this.metaParser = new MetaCSVParser(rows, this.header, this.objectParser);
        }
        return this.metaParser;
    }

    private Iterable<? extends Iterable<String>> buildRows() throws MetaCSVParseException, IOException {
        Iterable<? extends Iterable<String>> rows = this.metaTriplets == null ? (this.metaCSVDirectives == null ? this.buildRowsFromStreamOrFile() : this.buildRowsFromDirectives()) : this.metaTriplets;
        return rows;
    }

    private Iterable<? extends Iterable<String>> buildRowsFromDirectives() throws IOException {
        StringReader reader = new StringReader(Util.join(this.metaCSVDirectives, "\r\n"));
        return CSVFormat.RFC4180.parse((Reader)reader);
    }

    private Iterable<? extends Iterable<String>> buildRowsFromStreamOrFile() throws MetaCSVParseException, IOException {
        if (this.metaIn == null) {
            if (this.metaCSVFile == null) {
                throw new MetaCSVParseException("");
            }
            this.metaIn = new FileInputStream(this.metaCSVFile);
        }
        InputStreamReader reader = new InputStreamReader(this.metaIn);
        return new CSVParser((Reader)reader, CSVFormat.DEFAULT);
    }
}

