/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVFormatHelper;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVDataException;
import com.github.jferard.javamcsv.MetaCSVParseException;
import com.github.jferard.javamcsv.MetaCSVParser;
import com.github.jferard.javamcsv.MetaCSVParserBuilder;
import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.MetaCSVReader;
import com.github.jferard.javamcsv.ObjectTypeParser;
import com.github.jferard.javamcsv.OnError;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.processor.CSVRecordProcessor;
import com.github.jferard.javamcsv.processor.ProcessorProvider;
import com.github.jferard.javamcsv.processor.ReadProcessorProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.TimeZone;
import org.apache.commons.csv.CSVFormat;

public class MetaCSVReaderBuilder {
    private final MetaCSVParserBuilder parserBuilder = new MetaCSVParserBuilder();
    private TimeZone timeZone;
    private File csvFile;
    private InputStream csvIn;
    private MetaCSVData data;
    private OnError onError = OnError.WRAP;

    public MetaCSVReaderBuilder() {
        this.timeZone = Util.UTC_TIME_ZONE;
    }

    public MetaCSVReaderBuilder csvFile(File csvFile) {
        this.csvFile = csvFile;
        File metaCSVFile = Util.withExtension(csvFile, ".mcsv");
        this.parserBuilder.metaCSVFile(metaCSVFile);
        return this;
    }

    public MetaCSVReaderBuilder csvIn(InputStream csvIn) {
        this.csvIn = csvIn;
        return this;
    }

    public MetaCSVReaderBuilder metaCSVFile(File metaCSVFile) {
        this.parserBuilder.metaCSVFile(metaCSVFile);
        return this;
    }

    public MetaCSVReaderBuilder metaCSVDirectives(String ... metaCSVDirectives) {
        this.parserBuilder.metaCSVDirectives(metaCSVDirectives);
        return this;
    }

    public MetaCSVReaderBuilder metaCSVTriplets(Iterable<? extends Iterable<String>> metaTriplets) {
        this.parserBuilder.metaTriplets(metaTriplets);
        return this;
    }

    public MetaCSVReaderBuilder metaIn(InputStream metaIn) {
        this.parserBuilder.metaIn(metaIn);
        return this;
    }

    public MetaCSVReaderBuilder metaParser(MetaCSVParser metaParser) {
        this.parserBuilder.metaParser(metaParser);
        return this;
    }

    public MetaCSVReaderBuilder timeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public MetaCSVReaderBuilder metaData(MetaCSVData data) {
        this.data = data;
        return this;
    }

    public MetaCSVReaderBuilder onError(OnError onError) {
        this.onError = onError;
        return this;
    }

    public MetaCSVReader build() throws IOException, MetaCSVParseException, MetaCSVDataException, MetaCSVReadException {
        MetaCSVData data = this.getData();
        if (this.csvIn == null) {
            this.csvIn = new FileInputStream(this.csvFile);
        }
        return this.create(this.csvIn, data);
    }

    private MetaCSVData getData() throws MetaCSVParseException, IOException, MetaCSVDataException {
        if (this.data == null) {
            return this.parserBuilder.buildData();
        }
        return this.data;
    }

    private MetaCSVReader create(InputStream csvIn, MetaCSVData data) throws IOException, MetaCSVReadException {
        if (data.isUtf8BOM()) {
            this.gobbleBOM(csvIn);
        }
        InputStreamReader reader = new InputStreamReader(csvIn, data.getEncoding());
        CSVFormat format = CSVFormatHelper.getCSVFormat(data);
        ProcessorProvider processorProvider = data.toProcessorProvider(data.getNullValue());
        ReadProcessorProvider readProcessorProvider = data.toReadProcessorProvider(this.onError);
        CSVRecordProcessor processor = new CSVRecordProcessor(processorProvider, readProcessorProvider, this.onError, this.timeZone);
        return new MetaCSVReader(format.parse((Reader)reader), processor, data.getMetaData());
    }

    private void gobbleBOM(InputStream csvIn) throws IOException, MetaCSVReadException {
        byte[] buffer = new byte[3];
        int count = 0;
        while (count < 3) {
            count = csvIn.read(buffer, count, 3 - count);
        }
        if ((buffer[0] & 0xFF) != 239 || (buffer[1] & 0xFF) != 187 || (buffer[2] & 0xFF) != 191) {
            throw new MetaCSVReadException("BOM expected");
        }
    }

    public MetaCSVReaderBuilder objectParser(ObjectTypeParser objectParser) {
        this.parserBuilder.objectParser(objectParser);
        return this;
    }
}

