/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.MetaCSVRecord;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class Util {
    public static final String CRLF = "\r\n";
    public static final Charset ASCII_CHARSET = Charset.forName("US-ASCII");
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    public static String UTF_8_CHARSET_NAME = "UTF-8";

    public static List<String> parse(String s) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder cur = new StringBuilder();
        boolean backslash = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (backslash) {
                if (c != '\\' && c != '/') {
                    cur.append('\\');
                }
                cur.append(c);
                backslash = false;
                continue;
            }
            if (c == '\\') {
                backslash = true;
                continue;
            }
            if (c == '/') {
                parts.add(cur.toString());
                cur = new StringBuilder();
                continue;
            }
            cur.append(c);
        }
        parts.add(cur.toString());
        return parts;
    }

    public static void render(Appendable out, String ... values) throws IOException {
        int len = Util.getActualLength(values);
        if (len == 0) {
            return;
        }
        Util.render_escaped(out, values[0]);
        for (int i = 1; i < len; ++i) {
            out.append('/');
            Util.render_escaped(out, values[i]);
        }
    }

    private static int getActualLength(String[] values) {
        for (int last = values.length - 1; last >= 0; --last) {
            if (values[last].isEmpty()) continue;
            return last + 1;
        }
        return 0;
    }

    private static void render_escaped(Appendable out, String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '/' || c == '\\') {
                out.append('\\');
            }
            out.append(c);
        }
    }

    public static String render(String ... values) throws IOException {
        StringBuilder sb = new StringBuilder();
        Util.render(sb, values);
        return sb.toString();
    }

    public static String escapeLineTerminator(String lineTerminator) {
        if (lineTerminator.equals(CRLF)) {
            return "\\r\\n";
        }
        if (lineTerminator.equals("\n")) {
            return "\\n";
        }
        if (lineTerminator.equals("\r")) {
            return "\\r";
        }
        return lineTerminator;
    }

    public static String unescapeLineTerminator(String lineTerminatorRepr) {
        if (lineTerminatorRepr.equals("\\r\\n")) {
            return CRLF;
        }
        if (lineTerminatorRepr.equals("\\n")) {
            return "\n";
        }
        if (lineTerminatorRepr.equals("\\r")) {
            return "\r";
        }
        return lineTerminatorRepr;
    }

    public static File withExtension(File csvFile, String newExtension) {
        String absolutePath = csvFile.getAbsolutePath();
        int dotIndex = absolutePath.lastIndexOf(".");
        if (dotIndex == -1) {
            return new File(absolutePath + newExtension);
        }
        return new File(absolutePath.substring(0, dotIndex) + newExtension);
    }

    public static String replaceChar(String text, String ch, String newCh) {
        if (ch == null || ch.isEmpty()) {
            return text;
        }
        return text.replace(ch, newCh);
    }

    public static String getLocaleString(Locale locale) {
        return locale.getLanguage() + "_" + locale.getCountry();
    }

    public static List<String> header(MetaCSVRecord headerRecord) throws MetaCSVReadException {
        int size = headerRecord.size();
        ArrayList<String> ret = new ArrayList<String>(size);
        for (int c = 0; c < size; ++c) {
            ret.add(headerRecord.getText(c).toString());
        }
        return ret;
    }

    public static String join(String[] chunks, String delimiter) {
        if (chunks.length == 0) {
            return "";
        }
        if (chunks.length == 1) {
            return chunks[0];
        }
        StringBuilder sb = new StringBuilder(chunks[0]);
        for (int i = 1; i < chunks.length; ++i) {
            sb.append(delimiter).append(chunks[i]);
        }
        return sb.toString();
    }

    public static String formatLong(long n, String thousandsSeparator) {
        String text = Long.toString(n);
        if (thousandsSeparator == null || thousandsSeparator.isEmpty()) {
            return text;
        }
        boolean isNegative = n < 0L;
        int len = text.length();
        StringBuilder ret = new StringBuilder();
        Util.appendIntegerPart(ret, text, isNegative, len, thousandsSeparator);
        return ret.toString();
    }

    public static String formatDouble(double d, String thousandsSeparator, String decimalSeparator) {
        String text = Double.toString(d);
        boolean isNegative = d < 0.0;
        return Util.formatNumber(text, isNegative, thousandsSeparator, decimalSeparator);
    }

    public static String formatBigDecimal(BigDecimal bd, String thousandsSeparator, String decimalSeparator) {
        String text = bd.toString();
        if (!text.contains(".")) {
            text = text + ".0";
        } else {
            int i;
            for (i = text.length() - 1; i >= 0 && text.charAt(i) == '0'; --i) {
            }
            text = text.charAt(i) == '.' ? text.substring(0, i + 2) : text.substring(0, i + 1);
        }
        boolean isNegative = bd.signum() == -1;
        return Util.formatNumber(text, isNegative, thousandsSeparator, decimalSeparator);
    }

    private static String formatNumber(String text, boolean isNegative, String thousandsSeparator, String decimalSeparator) {
        boolean defaultDecimalSeparator;
        boolean defaultThousandsSeparator = thousandsSeparator == null || thousandsSeparator.isEmpty();
        boolean bl = defaultDecimalSeparator = decimalSeparator == null || decimalSeparator.equals(".");
        if (defaultThousandsSeparator && defaultDecimalSeparator) {
            return text;
        }
        int sepIndex = text.indexOf(".");
        StringBuilder ret = new StringBuilder();
        if (defaultThousandsSeparator) {
            ret.append(text, 0, sepIndex);
        } else {
            Util.appendIntegerPart(ret, text, isNegative, sepIndex, thousandsSeparator);
        }
        if (defaultDecimalSeparator) {
            ret.append(text, sepIndex, text.length());
        } else {
            ret.append(decimalSeparator);
            ret.append(text, sepIndex + 1, text.length());
        }
        return ret.toString();
    }

    public static void appendIntegerPart(StringBuilder ret, String text, boolean isNegative, int limit, String thousandsSeparator) {
        int t;
        int s;
        if (isNegative) {
            s = 1;
            t = (limit - 1) % 3 + 1;
            if (t == 1) {
                t = 4;
            }
            ret.append("-");
        } else {
            s = 0;
            t = limit % 3;
            if (t == 0) {
                t = 3;
            }
        }
        while (t < limit) {
            ret.append(text, s, t);
            ret.append(thousandsSeparator);
            s = t;
            t += 3;
        }
        ret.append(text, s, t);
    }

    public static long parseLong(String s, String thousandsSeparator) {
        String text = thousandsSeparator == null || thousandsSeparator.isEmpty() ? s : Util.replaceChar(s, thousandsSeparator, "");
        return Long.parseLong(text);
    }

    public static double parseDouble(String s, String thousandsSeparator, String decimalSeparator) {
        String text = Util.normalizeText(s, thousandsSeparator, decimalSeparator);
        return Double.parseDouble(text);
    }

    private static String normalizeText(String s, String thousandsSeparator, String decimalSeparator) {
        String text = thousandsSeparator == null || thousandsSeparator.isEmpty() ? s : Util.replaceChar(s, thousandsSeparator, "");
        if (decimalSeparator != null && !decimalSeparator.equals(".")) {
            text = Util.replaceChar(text, decimalSeparator, ".");
        }
        return text;
    }

    public static BigDecimal parseBigDecimal(String s, String thousandsSeparator, String decimalSeparator) {
        String text = Util.normalizeText(s, thousandsSeparator, decimalSeparator);
        return new BigDecimal(text);
    }

    public static Locale getLocale(String locale) {
        String[] s = locale.split("_");
        Locale instance = s.length == 2 ? new Locale(s[0], s[1]) : new Locale(s[0]);
        return instance;
    }

    public static boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

