/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.description;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.BooleanFieldProcessor;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.io.IOException;

public class BooleanFieldDescription
implements FieldDescription<Boolean> {
    public static final FieldDescription<?> INSTANCE = new BooleanFieldDescription("true", "false");
    private final String trueWord;
    private final String falseWord;

    public BooleanFieldDescription(String trueWord, String falseWord) {
        this.trueWord = trueWord;
        this.falseWord = falseWord;
    }

    @Override
    public void render(Appendable out) throws IOException {
        if (this.falseWord.isEmpty()) {
            Util.render(out, "boolean", this.trueWord);
        } else {
            Util.render(out, "boolean", this.trueWord, this.falseWord);
        }
    }

    @Override
    public FieldProcessor<Boolean> toFieldProcessor(String nullValue) {
        return new BooleanFieldProcessor(this.trueWord, this.falseWord, nullValue);
    }

    @Override
    public Class<Boolean> getJavaType() {
        return Boolean.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOLEAN;
    }

    public String toString() {
        return String.format("BooleanFieldDescription(%s, %s)", this.trueWord, this.falseWord);
    }
}

