/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVRecord;
import com.github.jferard.javamcsv.OnError;
import com.github.jferard.javamcsv.processor.ProcessorProvider;
import com.github.jferard.javamcsv.processor.ReadFieldProcessor;
import com.github.jferard.javamcsv.processor.ReadProcessorProvider;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.commons.csv.CSVRecord;

public class CSVRecordProcessor {
    private final ProcessorProvider provider;
    private final TimeZone timeZone;
    private int maxSize;
    private ReadProcessorProvider readProcessorProvider;
    private OnError onError;
    private final HashMap<Integer, ReadFieldProcessor<?>> processorByIndex;

    public CSVRecordProcessor(ProcessorProvider provider, ReadProcessorProvider readProcessorProvider, OnError onError, TimeZone timeZone) {
        this.provider = provider;
        this.readProcessorProvider = readProcessorProvider;
        this.onError = onError;
        this.maxSize = 0;
        this.processorByIndex = new HashMap();
        this.timeZone = timeZone;
    }

    public MetaCSVRecord createRecord(CSVRecord record) {
        if (this.maxSize < record.size()) {
            this.updateProcessorByIndex(record);
            this.maxSize = record.size();
        }
        return new MetaCSVRecord(record, this.provider, this.readProcessorProvider, this.processorByIndex, this.timeZone);
    }

    private void updateProcessorByIndex(CSVRecord record) {
        for (int i = this.maxSize; i < record.size(); ++i) {
            ReadFieldProcessor<?> processor = this.processorByIndex.get(i);
            if (processor != null) continue;
            processor = this.readProcessorProvider.getProcessor(i);
            this.processorByIndex.put(i, processor);
        }
    }
}

