/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.description.TextFieldDescription;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProcessorProvider {
    private final Map<Integer, FieldDescription<?>> descriptionByColIndex;
    private final String nullValue;
    private final List<FieldProcessor<?>> processors;

    public ProcessorProvider(Map<Integer, FieldDescription<?>> descriptionByColIndex, String nullValue) {
        this.descriptionByColIndex = descriptionByColIndex;
        this.nullValue = nullValue;
        this.processors = new ArrayList();
    }

    public FieldProcessor<?> getProcessor(int c) {
        while (c >= this.processors.size()) {
            this.processors.add(null);
        }
        FieldProcessor<?> processor = this.processors.get(c);
        if (processor == null) {
            processor = this.createProcessor(c);
            this.processors.set(c, processor);
        }
        return processor;
    }

    private FieldProcessor<?> createProcessor(int c) {
        FieldDescription<Object> fieldDescription = this.descriptionByColIndex.get(c);
        if (fieldDescription == null) {
            fieldDescription = TextFieldDescription.INSTANCE;
        }
        return fieldDescription.toFieldProcessor(this.nullValue);
    }
}

