/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.tool;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.MetaCSVReader;
import com.github.jferard.javamcsv.MetaCSVRecord;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.tool.AbstractResultSet;
import com.github.jferard.javamcsv.tool.MetaCSVResultSetMetaData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class MetaCSVReaderResultSet
extends AbstractResultSet {
    private final Map<String, Integer> indexByLabel;
    private final List<String> header;
    private Iterator<MetaCSVRecord> iterator;
    private MetaCSVReader reader;
    private MetaCSVRecord cur;
    private boolean wasNull;

    public MetaCSVReaderResultSet(MetaCSVReader reader) throws MetaCSVReadException {
        this.reader = reader;
        this.iterator = reader.iterator();
        MetaCSVRecord headerRecord = this.iterator.next();
        this.header = Util.header(headerRecord);
        this.indexByLabel = new HashMap<String, Integer>();
        for (int i = 0; i < this.header.size(); ++i) {
            this.indexByLabel.put(this.header.get(i), i + 1);
        }
        this.cur = null;
        this.wasNull = false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.iterator == null) {
            throw new SQLException();
        }
        boolean ret = this.iterator.hasNext();
        if (ret) {
            this.cur = this.iterator.next();
        }
        return ret;
    }

    @Override
    public void close() throws SQLException {
        this.iterator = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object o = this.getCurObject(columnIndex);
        if (o == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return o.toString();
    }

    private Object getCurObject(int columnIndex) throws SQLException {
        try {
            return this.cur.getObject(columnIndex - 1);
        }
        catch (MetaCSVReadException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object o = this.getCurObject(columnIndex);
        if (o == null) {
            this.wasNull = true;
            return false;
        }
        this.wasNull = false;
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof CharSequence) {
            if (o.equals("1")) {
                return true;
            }
            if (o.equals("0")) {
                return false;
            }
        } else {
            if (o instanceof Long) {
                long i = (Long)o;
                if (i == 1L) {
                    return true;
                }
                if (i == 0L) {
                    return false;
                }
                throw new SQLException("Bad boolean: " + o);
            }
            if (o instanceof Double) {
                double d = (Double)o;
                if (d == 1.0) {
                    return true;
                }
                if (d == 0.0) {
                    return false;
                }
            } else if (o instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)o;
                if (bd.compareTo(BigDecimal.ONE) == 0) {
                    return true;
                }
                if (bd.compareTo(BigDecimal.ZERO) == 0) {
                    return false;
                }
            }
        }
        throw new SQLException("Bad boolean: " + o);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (byte)this.getLong("Byte", columnIndex, -128L, 127L);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (short)this.getLong("Short", columnIndex, -32768L, 32767L);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return (int)this.getLong("Int", columnIndex, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getLong("Long", columnIndex);
    }

    private long getLong(String typeName, int columnIndex, long minValue, long maxValue) throws SQLException {
        long l = this.getLong(typeName, columnIndex);
        if (minValue <= l && l <= maxValue) {
            return l;
        }
        throw new SQLException("Bad " + typeName + ": " + l);
    }

    private long getLong(String typeName, int columnIndex) throws SQLException {
        Object o = this.getCurObject(columnIndex);
        if (o == null) {
            this.wasNull = true;
            return 0L;
        }
        this.wasNull = false;
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new SQLException("Bad " + typeName + ": `" + o + "`");
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Number n = this.getNumber("float", columnIndex);
        return n.floatValue();
    }

    private Number getNumber(String typeName, int columnIndex) throws SQLException {
        Object o = this.getCurObject(columnIndex);
        if (o == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        throw new SQLException("Bad " + typeName + ": " + o);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Number n = this.getNumber("double", columnIndex);
        return n.doubleValue();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return s.getBytes(Util.UTF_8_CHARSET);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        java.util.Date date = this.getDate("Date", columnIndex);
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    private java.util.Date getDate(String typeName, int columnIndex) throws SQLException {
        Object o = this.getCurObject(columnIndex);
        if (o == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (o instanceof java.util.Date) {
            return (java.util.Date)o;
        }
        throw new SQLException("Bad " + typeName + ": " + o);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return new Time(this.getDate("Date", columnIndex).getTime());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return new Timestamp(this.getDate("Date", columnIndex).getTime());
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new ByteArrayInputStream(s.getBytes(Util.ASCII_CHARSET));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new ByteArrayInputStream(s.getBytes(Util.UTF_8_CHARSET));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new MetaCSVResultSetMetaData(this.reader.getMetaData(), this.header, this.indexByLabel);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getCurObject(columnIndex);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Integer columnIndex = this.indexByLabel.get(columnLabel);
        if (columnIndex == null) {
            throw new SQLException("Unknown label: " + columnLabel);
        }
        return columnIndex;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return new StringReader(this.getString(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object o = this.getCurObject(columnIndex);
        if (o == null) {
            this.wasNull = true;
            return BigDecimal.ZERO;
        }
        this.wasNull = false;
        if (o instanceof Long || o instanceof Double) {
            return new BigDecimal(o.toString());
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        throw new SQLException("Bad BigDecimal: " + o);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLException();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date d = this.getDate(columnIndex);
        long millis = this.getMillis(d, cal);
        return new Date(millis);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time t = this.getTime(columnIndex);
        long millis = this.getMillis(t, cal);
        return new Time(millis);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp t = this.getTimestamp(columnIndex);
        long millis = this.getMillis(t, cal);
        return new Timestamp(millis);
    }

    private long getMillis(java.util.Date date, Calendar cal) {
        TimeZone tz = cal.getTimeZone();
        long time = date.getTime();
        return time + (long)tz.getOffset(time);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.iterator == null || !this.iterator.hasNext();
    }

    @Override
    public int getRow() throws SQLException {
        return (int)this.reader.getRow();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return (T)this.getObject(columnIndex);
    }
}

