/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.MetaCSVParseException;
import java.util.Iterator;

public class MetaCSVRow {
    private final String domain;
    private final String key;
    private final String value;

    public static MetaCSVRow fromIterable(Iterable<String> iterable) throws MetaCSVParseException {
        Iterator<String> it = iterable.iterator();
        if (!it.hasNext()) {
            throw new MetaCSVParseException("Bad header: empty");
        }
        String domain = it.next();
        if (!it.hasNext()) {
            throw new MetaCSVParseException(String.format("Bad header: one element (%s)", domain));
        }
        String key = it.next();
        if (!it.hasNext()) {
            throw new MetaCSVParseException(String.format("Bad header: two elements (%s, %s)", domain, key));
        }
        String value = it.next();
        if (it.hasNext()) {
            throw new MetaCSVParseException(String.format("Bad header: more elements: %s, %s, %s, %s, ...", domain, key, value, it.next()));
        }
        return new MetaCSVRow(domain, key, value);
    }

    public MetaCSVRow(String domain, String key, String value) {
        this.domain = domain;
        this.key = key;
        this.value = value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "MetaCSVRow{domain='" + this.domain + '\'' + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

