/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv;

import com.github.jferard.javamcsv.CSVFormatHelper;
import com.github.jferard.javamcsv.MetaCSVData;
import com.github.jferard.javamcsv.MetaCSVRenderer;
import com.github.jferard.javamcsv.MetaCSVWriter;
import com.github.jferard.javamcsv.OnError;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.processor.WriteProcessorProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class MetaCSVWriterBuilder {
    private File csvFile;
    private File metaCSVFile;
    private MetaCSVData data;
    private OutputStream out;
    private OutputStream metaOut;
    private MetaCSVRenderer metaRenderer;
    private Appendable writer;
    private OnError onError = OnError.EXCEPTION;

    MetaCSVWriterBuilder() {
    }

    public MetaCSVWriterBuilder csvFile(File csvFile) {
        this.csvFile = csvFile;
        return this;
    }

    public MetaCSVWriterBuilder metaData(MetaCSVData data) {
        this.data = data;
        return this;
    }

    public MetaCSVWriterBuilder metaCSVFile(File metaCSVFile) {
        this.metaCSVFile = metaCSVFile;
        return this;
    }

    public MetaCSVWriterBuilder out(OutputStream out) {
        this.out = out;
        return this;
    }

    public MetaCSVWriterBuilder metaOut(OutputStream metaOut) {
        this.metaOut = metaOut;
        return this;
    }

    public MetaCSVWriterBuilder metaRenderer(MetaCSVRenderer renderer) {
        this.metaRenderer = renderer;
        return this;
    }

    public MetaCSVWriterBuilder onError(OnError onError) {
        this.onError = onError;
        return this;
    }

    public MetaCSVWriter build() throws IOException {
        this.writeData();
        if (this.writer == null) {
            if (this.out == null) {
                this.out = new FileOutputStream(this.csvFile);
            }
            this.writer = new OutputStreamWriter(this.out, this.data.getEncoding());
        }
        CSVFormat format = CSVFormatHelper.getCSVFormat(this.data);
        CSVPrinter printer = new CSVPrinter(this.writer, format);
        WriteProcessorProvider writeProvider = this.data.toWriteProcessorProvider(this.onError);
        return new MetaCSVWriter(printer, writeProvider);
    }

    private void writeData() throws IOException {
        if (this.metaRenderer == null) {
            if (this.metaOut == null) {
                if (this.metaCSVFile == null) {
                    if (this.csvFile == null) {
                        return;
                    }
                    this.metaCSVFile = Util.withExtension(this.csvFile, ".mcsv");
                }
                this.metaOut = new FileOutputStream(this.metaCSVFile);
                this.metaRenderer = MetaCSVRenderer.create(this.metaOut);
                try {
                    this.metaRenderer.render(this.data);
                }
                finally {
                    this.metaOut.close();
                }
            } else {
                this.metaRenderer = MetaCSVRenderer.create(this.metaOut);
                this.metaRenderer.render(this.data);
            }
        } else {
            this.metaRenderer.render(this.data);
        }
    }
}

