/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.description;

import com.github.jferard.javamcsv.DataType;
import com.github.jferard.javamcsv.description.FieldDescription;
import com.github.jferard.javamcsv.processor.FieldProcessor;
import com.github.jferard.javamcsv.processor.FloatFieldProcessor;
import java.io.IOException;

public class FloatFieldDescription
implements FieldDescription<Double> {
    public static final FieldDescription<Double> INSTANCE = new FloatFieldDescription("", ".");
    private String thousandsSeparator;
    private String decimalSeparator;
    private String nullValue;

    public FloatFieldDescription(String thousandsSeparator, String decimalSeparator) {
        this.thousandsSeparator = thousandsSeparator;
        this.decimalSeparator = decimalSeparator;
        this.nullValue = "";
    }

    @Override
    public void render(Appendable out) throws IOException {
        if (this.thousandsSeparator.isEmpty()) {
            out.append("float//");
        } else {
            out.append("float/").append(this.thousandsSeparator).append('/');
        }
        out.append(this.decimalSeparator);
    }

    @Override
    public FieldProcessor<Double> toFieldProcessor(String nullValue) {
        return new FloatFieldProcessor(this.thousandsSeparator, this.decimalSeparator, nullValue);
    }

    @Override
    public Class<Double> getJavaType() {
        return Double.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public String toString() {
        return String.format("FloatFieldDescription(%s, %s)", this.thousandsSeparator, this.decimalSeparator);
    }
}

