/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.processor.FieldProcessor;

public class CurrencyIntegerFieldProcessor
implements FieldProcessor<Long> {
    private final boolean pre;
    private final String symbol;
    private final FieldProcessor<Long> numberProcessor;
    private final String nullValue;

    public CurrencyIntegerFieldProcessor(boolean pre, String symbol, FieldProcessor<Long> numberProcessor, String nullValue) {
        this.pre = pre;
        this.symbol = symbol;
        this.numberProcessor = numberProcessor;
        this.nullValue = nullValue;
    }

    @Override
    public Long toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        text = Util.cleanCurrencyText(text, this.pre, this.symbol);
        return this.numberProcessor.toObject(text);
    }

    @Override
    public String toString(Long value) {
        if (value == null) {
            return this.nullValue;
        }
        String valueAsString = this.numberProcessor.toString(value);
        if (this.pre) {
            return this.symbol + valueAsString;
        }
        return valueAsString + " " + this.symbol;
    }

    @Override
    public String toCanonicalString(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return "";
        }
        text = Util.cleanCurrencyText(text, this.pre, this.symbol);
        return this.numberProcessor.toCanonicalString(text);
    }

    @Override
    public Long cast(Object o) {
        return this.numberProcessor.cast(o);
    }
}

