/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.javamcsv.processor;

import com.github.jferard.javamcsv.MetaCSVReadException;
import com.github.jferard.javamcsv.Util;
import com.github.jferard.javamcsv.processor.FieldProcessor;

public class IntegerFieldProcessor
implements FieldProcessor<Long> {
    private final String thousandsSeparator;
    private final String nullValue;

    public IntegerFieldProcessor(String thousandsSeparator, String nullValue) {
        this.thousandsSeparator = thousandsSeparator;
        this.nullValue = nullValue;
    }

    @Override
    public Long toObject(String text) throws MetaCSVReadException {
        if (text == null || text.equals(this.nullValue)) {
            return null;
        }
        try {
            return Util.parseLong(text, this.thousandsSeparator);
        }
        catch (NumberFormatException e) {
            throw new MetaCSVReadException(e);
        }
    }

    @Override
    public String toString(Long n) {
        if (n == null) {
            return this.nullValue;
        }
        return Util.formatLong(n, this.thousandsSeparator);
    }

    @Override
    public String toCanonicalString(String text) {
        if (text == null || text.equals(this.nullValue)) {
            return "";
        }
        return Util.normalizeIntegerText(text, this.thousandsSeparator);
    }

    @Override
    public Long cast(Object o) {
        if (o == null || o instanceof Long) {
            return (Long)o;
        }
        return ((Number)o).longValue();
    }
}

