/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.extend;

import com.github.jknack.extend.Function;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import net.sf.cglib.beans.BeanGenerator;
import net.sf.cglib.beans.BeanMap;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang3.Validate;

public final class Extend {
    private Extend() {
    }

    public static Property $(String name, Object value) {
        return new Property(name, value);
    }

    public static <T> List<T> extend(Iterable<T> sources, Property ... properties) {
        Validate.notNull(sources, (String)"The source object is required.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])properties, (String)"The properties is required", (Object[])new Object[0]);
        ArrayList<T> result = new ArrayList<T>();
        for (T source : sources) {
            result.add(Extend.extend(source, properties));
        }
        return result;
    }

    public static <T> T extend(T source, Property ... properties) {
        Validate.notNull(source, (String)"The source object is required.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])properties, (String)"The properties is required", (Object[])new Object[0]);
        return Extend.extend(source, Extend.toMap(properties));
    }

    public static <T> List<T> extend(Iterable<T> sources, Map<String, Object> properties) {
        Validate.notNull(sources, (String)"The sources object is required.", (Object[])new Object[0]);
        Validate.notEmpty(properties, (String)"The properties is required", (Object[])new Object[0]);
        ArrayList<T> result = new ArrayList<T>();
        for (T source : sources) {
            result.add(Extend.extend(source, properties));
        }
        return result;
    }

    public static <T> T extend(T source, Map<String, Object> properties) {
        Validate.notNull(source, (String)"The source object is required.", (Object[])new Object[0]);
        Validate.notEmpty(properties, (String)"The properties is required", (Object[])new Object[0]);
        BeanGenerator beanGenerator = new BeanGenerator();
        beanGenerator.setSuperclass(source.getClass());
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            Object value = property.getValue();
            if (value == null) continue;
            Class<Object> propertyType = value.getClass();
            if (value instanceof Function) {
                propertyType = Object.class;
            }
            beanGenerator.addProperty(property.getKey(), propertyType);
        }
        Class extendedClass = (Class)beanGenerator.createClass();
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(extendedClass);
        enhancer.setCallback((Callback)new ExtendInterceptor(source, properties));
        return (T)enhancer.create();
    }

    public static <T> Map<String, Object> map(T source, Property ... properties) {
        return Extend.map(source, Extend.toMap(properties));
    }

    public static <T> List<Map<String, Object>> map(Iterable<T> sources, Property ... properties) {
        return Extend.map(sources, Extend.toMap(properties));
    }

    public static <T> List<Map<String, Object>> map(Iterable<T> sources, Map<String, Object> properties) {
        Validate.notNull(sources, (String)"The sources object is required.", (Object[])new Object[0]);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (T source : sources) {
            result.add(Extend.map(source, properties));
        }
        return result;
    }

    public static <T> Map<String, Object> map(T source, final Map<String, Object> properties) {
        Validate.notNull(source, (String)"The source object is required.", (Object[])new Object[0]);
        Validate.notNull(properties, (String)"The properties is required", (Object[])new Object[0]);
        final BeanMap beanMap = BeanMap.create(source);
        return new AbstractMap<String, Object>(){

            @Override
            public Object put(String key, Object value) {
                return null;
            }

            @Override
            public Object get(Object key) {
                Object value = properties.get(key);
                return value == null ? beanMap.get(key) : value;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                LinkedHashMap mergedProperties = new LinkedHashMap(beanMap);
                mergedProperties.putAll(properties);
                return mergedProperties.entrySet();
            }
        };
    }

    private static Map<String, Object> toMap(Property ... properties) {
        LinkedHashMap<String, Object> hash = new LinkedHashMap<String, Object>();
        for (Property property : properties) {
            hash.put(property.name, property.value);
        }
        return hash;
    }

    public static final class Property {
        public final String name;
        public final Object value;

        private Property(String name, Object value) {
            this.name = (String)Validate.notEmpty((CharSequence)name, (String)"The name is required.", (Object[])new Object[0]);
            this.value = Validate.notNull((Object)value, (String)"The value is required.", (Object[])new Object[0]);
        }
    }

    static class ExtendInterceptor
    implements MethodInterceptor {
        private Object source;
        private Map<String, Object> properties;
        private static final Object UNRESOLVED = new Object();

        public ExtendInterceptor(Object source, Map<String, Object> properties) {
            this.source = source;
            this.properties = properties;
        }

        private Object resolve(Callable<Object> ... resolvers) throws Exception {
            for (Callable<Object> resolver : resolvers) {
                Object value = resolver.call();
                if (value == UNRESOLVED) continue;
                return value;
            }
            return null;
        }

        private static Callable<Object> asMethod(final Method method, final Object source, final Object[] args) {
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return method.invoke(source, args);
                }
            };
        }

        private Callable<Object> asMapEntry(final String methodName, Object ... args) {
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String prefix = "get";
                    if (methodName.startsWith(prefix)) {
                        StringBuilder buffer = new StringBuilder(methodName.substring(prefix.length()));
                        buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
                        String propertyName = buffer.toString();
                        if (ExtendInterceptor.this.properties.containsKey(propertyName)) {
                            return ExtendInterceptor.this.properties.get(propertyName);
                        }
                        return UNRESOLVED;
                    }
                    return UNRESOLVED;
                }
            };
        }

        public Object intercept(Object extended, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            String methodName = method.getName();
            if (methodName.startsWith("set")) {
                return null;
            }
            if ("hashCode".equals(methodName)) {
                return this.source.hashCode();
            }
            if ("equals".equals(methodName)) {
                return this.source.equals(args[0]);
            }
            Callable[] resolvers = new Callable[]{this.asMapEntry(methodName, args), ExtendInterceptor.asMethod(method, this.source, args)};
            Object value = this.resolve(resolvers);
            if (value instanceof Function) {
                value = ((Function)value).apply(this.source);
            }
            return value;
        }
    }
}

