/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.api;

import com.github.jmodel.api.Analyzer;
import com.github.jmodel.api.FormatEnum;
import com.github.jmodel.spi.AnalyzerFactory;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class AnalyzerFactoryService {
    private static AnalyzerFactoryService service;
    private ServiceLoader<AnalyzerFactory> loader = ServiceLoader.load(AnalyzerFactory.class);

    private AnalyzerFactoryService() {
    }

    public static synchronized AnalyzerFactoryService getInstance() {
        if (service == null) {
            service = new AnalyzerFactoryService();
        }
        return service;
    }

    public Analyzer getAnalyzer(FormatEnum format, String extendAnalyzerName) {
        Analyzer analyzer = null;
        try {
            Iterator<AnalyzerFactory> analyzerFactorys = this.loader.iterator();
            while (analyzer == null && analyzerFactorys.hasNext()) {
                AnalyzerFactory analyzerFactory = analyzerFactorys.next();
                analyzer = analyzerFactory.getAnalyzer(format, extendAnalyzerName);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            analyzer = null;
            serviceError.printStackTrace();
        }
        return analyzer;
    }
}

