/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.api;

import com.github.jmodel.api.FormatChecker;
import com.github.jmodel.api.FormatEnum;
import com.github.jmodel.spi.FormatCheckerFactory;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class FormatCheckerFactoryService {
    private static FormatCheckerFactoryService service;
    private ServiceLoader<FormatCheckerFactory> loader = ServiceLoader.load(FormatCheckerFactory.class);

    private FormatCheckerFactoryService() {
    }

    public static synchronized FormatCheckerFactoryService getInstance() {
        if (service == null) {
            service = new FormatCheckerFactoryService();
        }
        return service;
    }

    public FormatChecker getFormatChecker(FormatEnum fromFormat) {
        FormatChecker formatChecker = null;
        try {
            Iterator<FormatCheckerFactory> formatCheckerFactorys = this.loader.iterator();
            while (formatChecker == null && formatCheckerFactorys.hasNext()) {
                FormatCheckerFactory formatCheckerFactory = formatCheckerFactorys.next();
                formatChecker = formatCheckerFactory.getFormatChecker(fromFormat);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            formatChecker = null;
            serviceError.printStackTrace();
        }
        return formatChecker;
    }
}

