/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.api;

import com.github.jmodel.api.ModelEngine;
import com.github.jmodel.spi.ModelEngineFactory;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class ModelEngineFactoryService {
    private static ModelEngineFactoryService service;
    private ServiceLoader<ModelEngineFactory> loader = ServiceLoader.load(ModelEngineFactory.class);

    private ModelEngineFactoryService() {
    }

    public static synchronized ModelEngineFactoryService getInstance() {
        if (service == null) {
            service = new ModelEngineFactoryService();
        }
        return service;
    }

    public ModelEngine get() {
        ModelEngine engine = null;
        try {
            Iterator<ModelEngineFactory> engineFactorys = this.loader.iterator();
            while (engine == null && engineFactorys.hasNext()) {
                ModelEngineFactory engineFactory = engineFactorys.next();
                engine = engineFactory.get();
            }
        }
        catch (ServiceConfigurationError serviceError) {
            engine = null;
            serviceError.printStackTrace();
        }
        return engine;
    }
}

