/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.api;

import com.github.jmodel.api.Field;
import com.github.jmodel.api.IllegalException;
import com.github.jmodel.api.OperationEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class ModelHelper {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat();
    private static final String BUNDLE_NAME = "com.github.jmodel.api.MessagesBundle";

    public static Date getDate(String fieldValue) {
        return ModelHelper.getDate(fieldValue, null);
    }

    public static Date getDate(String fieldValue, String pattern) {
        try {
            if (pattern == null) {
                return dateFormat.parse(fieldValue);
            }
            return new SimpleDateFormat(pattern).parse(fieldValue);
        }
        catch (ParseException parseException) {
            throw new IllegalException("failed to parse date string");
        }
    }

    public static String getFieldValue(Field field) {
        if (field == null) {
            return "";
        }
        return field.getValue();
    }

    public static <T1, T2> String calc(T1 leftOperant, T2 rightOperant, OperationEnum operation, Locale currentLocale) {
        ResourceBundle messages = ResourceBundle.getBundle(BUNDLE_NAME, currentLocale);
        switch (operation) {
            case PLUS: {
                if (leftOperant instanceof String || rightOperant instanceof String) {
                    return String.valueOf(String.valueOf(leftOperant)) + String.valueOf(rightOperant);
                }
                if (leftOperant instanceof Integer && rightOperant instanceof Integer) {
                    return String.valueOf((Integer)leftOperant + (Integer)rightOperant);
                }
                return null;
            }
            case MULTIPLY: {
                return String.valueOf(Integer.valueOf((String)leftOperant) * Integer.valueOf((String)rightOperant));
            }
        }
        throw new IllegalException(String.format(currentLocale, messages.getString("OPR_NOT_SUPPORT"), new Object[]{operation, "xxx"}));
    }

    public static Boolean predict(Comparable leftOperant, Comparable rightOperant, OperationEnum operation, Locale currentLocale) {
        ResourceBundle messages = ResourceBundle.getBundle(BUNDLE_NAME, currentLocale);
        if (leftOperant == null || rightOperant == null) {
            switch (operation) {
                case EQUALS: {
                    if (leftOperant == rightOperant) {
                        return true;
                    }
                    return false;
                }
                case NOTEQUALS: {
                    if (leftOperant != rightOperant) {
                        return true;
                    }
                    return false;
                }
            }
            throw new IllegalException(String.format(currentLocale, messages.getString("OPR_NOT_SUPPORT"), new Object[]{operation, "NULL"}));
        }
        int compareResult = leftOperant.compareTo(rightOperant);
        switch (operation) {
            case EQUALS: {
                return compareResult == 0;
            }
            case NOTEQUALS: {
                return compareResult != 0;
            }
            case GT: {
                return compareResult > 0;
            }
            case GTE: {
                return compareResult > 0 || compareResult == 0;
            }
            case LT: {
                return compareResult < 0;
            }
            case LTE: {
                return compareResult < 0 || compareResult == 0;
            }
        }
        throw new IllegalException(String.format(currentLocale, messages.getString("OPR_NOT_SUPPORT"), new Object[]{operation, "Comparable"}));
    }

    public static Boolean predict(String leftOperant, List<String> rightOperant, OperationEnum operation, Locale currentLocale) {
        ResourceBundle messages = ResourceBundle.getBundle(BUNDLE_NAME, currentLocale);
        switch (operation) {
            case IN: {
                return rightOperant.contains(leftOperant);
            }
            case NOTIN: {
                return !rightOperant.contains(leftOperant);
            }
        }
        throw new IllegalException(String.format(currentLocale, messages.getString("OPR_NOT_SUPPORT"), new Object[]{operation, "String and List"}));
    }

    public static Boolean predict(Boolean leftOperant, Boolean rightOperant, OperationEnum operation, Locale currentLocale) {
        ResourceBundle messages = ResourceBundle.getBundle(BUNDLE_NAME, currentLocale);
        switch (operation) {
            case OR: {
                return Boolean.logicalOr(leftOperant, rightOperant);
            }
            case AND: {
                return Boolean.logicalAnd(leftOperant, rightOperant);
            }
        }
        throw new IllegalException(String.format(currentLocale, messages.getString("OPR_NOT_SUPPORT"), new Object[]{operation, "Boolean"}));
    }
}

