/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.impl;

import com.github.jmodel.api.Analyzer;
import com.github.jmodel.api.Array;
import com.github.jmodel.api.Entity;
import com.github.jmodel.api.Field;
import com.github.jmodel.api.Model;
import java.util.List;
import java.util.Map;

public abstract class AbstractAnalyzer<T>
implements Analyzer {
    protected void build(Model sourceModel, Map<String, Field> fieldPathMap, Map<String, Model> modelPathMap, T node, Boolean isConstruction) {
        if (isConstruction.booleanValue()) {
            this.buildModel(sourceModel, fieldPathMap, modelPathMap, "", node);
        } else {
            this.setValueOfFields(sourceModel, fieldPathMap, modelPathMap, node);
        }
    }

    protected void setValueOfFields(Model sourceModel, Map<String, Field> fieldPathMap, Map<String, Model> modelPathMap, T node) {
        if (sourceModel != null) {
            sourceModel.setModelPathMap(modelPathMap);
            sourceModel.setFieldPathMap(fieldPathMap);
            if (sourceModel instanceof Entity) {
                Model parentModel;
                List fields;
                if (sourceModel.getModelPath() == null) {
                    sourceModel.setFieldPathMap(fieldPathMap);
                    sourceModel.setModelPath(sourceModel.getName());
                }
                if ((fields = ((Entity)sourceModel).getFields()) != null) {
                    for (Field field : fields) {
                        this.setFieldValue(node, field);
                        sourceModel.getFieldPathMap().put(sourceModel.getModelPath() + "." + field.getName(), field);
                    }
                }
                if ((parentModel = sourceModel.getParentModel()) != null) {
                    Array clonedArray;
                    if (parentModel instanceof Entity && sourceModel.isRecursive()) {
                        Entity clonedEntity = (Entity)sourceModel.clone();
                        if (this.getSubNode(node, clonedEntity.getName()) != null) {
                            clonedEntity.setRecursive(true);
                            clonedEntity.setParentModel(sourceModel);
                            sourceModel.getSubModels().add(clonedEntity);
                        }
                    } else if (parentModel instanceof Array && parentModel.isRecursive() && this.getSubNode(node, (clonedArray = (Array)parentModel.clone()).getName()) != null) {
                        clonedArray.setRecursive(true);
                        clonedArray.setParentModel(sourceModel);
                        sourceModel.getSubModels().add(clonedArray);
                    }
                }
            }
            modelPathMap.put(sourceModel.getModelPath(), sourceModel);
            List subModels = sourceModel.getSubModels();
            if (subModels != null) {
                for (Model subModel : subModels) {
                    T subNode = this.getSubNode(node, subModel.getName());
                    if (subNode == null) continue;
                    subModel.setFieldPathMap(fieldPathMap);
                    if (subModel instanceof Array) {
                        subModel.setModelPath(sourceModel.getModelPath() + "." + subModel.getName() + "[]");
                    } else {
                        subModel.setModelPath(sourceModel.getModelPath() + "." + subModel.getName());
                    }
                    if (subModel instanceof Entity) {
                        this.setValueOfFields(subModel, fieldPathMap, modelPathMap, subNode);
                        continue;
                    }
                    if (!(subModel instanceof Array)) continue;
                    modelPathMap.put(subModel.getModelPath(), subModel);
                    subModel.setModelPathMap(modelPathMap);
                    subModel.setFieldPathMap(fieldPathMap);
                    List subSubModels = subModel.getSubModels();
                    if (subSubModels == null) continue;
                    Model subSubModel = (Model)subSubModels.get(0);
                    this.populateSubModel(subNode, subModel, subSubModel);
                }
            }
        }
    }

    protected abstract void buildModel(Model var1, Map<String, Field> var2, Map<String, Model> var3, String var4, T var5);

    protected abstract void setFieldValue(T var1, Field var2);

    protected abstract T getSubNode(T var1, String var2);

    protected abstract void populateSubModel(T var1, Model var2, Model var3);
}

