/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.impl;

import com.github.jmodel.api.Analyzer;
import com.github.jmodel.api.AnalyzerFactoryService;
import com.github.jmodel.api.FormatChecker;
import com.github.jmodel.api.FormatCheckerFactoryService;
import com.github.jmodel.api.FormatEnum;
import com.github.jmodel.api.IllegalException;
import com.github.jmodel.api.Model;
import com.github.jmodel.api.ModelEngine;
import com.github.jmodel.impl.EntityImpl;
import java.util.Locale;
import java.util.ResourceBundle;

public class ModelEngineImpl
implements ModelEngine {
    private ResourceBundle messages;

    public Model construct(Object sourceObj, FormatEnum format) {
        return this.construct(sourceObj, format, Locale.getDefault());
    }

    public Model construct(Object sourceObj, FormatEnum format, Locale currentLocale) {
        Analyzer analyzer = this.getAnalyzer(sourceObj, format, currentLocale);
        Model model = analyzer.process((Model)new EntityImpl(), sourceObj, Boolean.valueOf(true));
        return model;
    }

    public Model fill(Model sourceModel, Object sourceObj, FormatEnum format) {
        return this.fill(sourceModel, sourceObj, format, Locale.getDefault());
    }

    public Model fill(Model sourceModel, Object sourceObj, FormatEnum format, Locale currentLocale) {
        Analyzer analyzer = this.getAnalyzer(sourceObj, format, currentLocale);
        Model model = analyzer.process(sourceModel, sourceObj, Boolean.valueOf(false));
        return model;
    }

    private Analyzer getAnalyzer(Object sourceObj, FormatEnum format, Locale currentLocale) {
        this.messages = ResourceBundle.getBundle("com.github.jmodel.api.MessagesBundle", currentLocale);
        if (sourceObj == null) {
            throw new IllegalException(this.messages.getString("SRC_IS_NULL"));
        }
        FormatChecker formatChecker = FormatCheckerFactoryService.getInstance().getFormatChecker(format);
        if (!formatChecker.isValid(sourceObj)) {
            throw new IllegalException(String.format(currentLocale, this.messages.getString("SRC_FMT_NOT_SUPPORT"), sourceObj.getClass().getName(), format));
        }
        AnalyzerFactoryService analyzerFactoryService = AnalyzerFactoryService.getInstance();
        Analyzer analyzer = analyzerFactoryService.getAnalyzer(format, null);
        return analyzer;
    }
}

