/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.impl;

import com.github.jmodel.api.Entity;
import com.github.jmodel.api.Field;
import com.github.jmodel.api.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ModelImpl
implements Model {
    private String name;
    private boolean isRecursive;
    private String modelPath;
    private Model parentModel;
    private boolean isUsed = false;
    private List<Model> subModels = new ArrayList<Model>();
    private Map<String, Field> fieldPathMap = new HashMap<String, Field>();
    private Map<String, Model> modelPathMap = new HashMap<String, Model>();
    private Object targetBean;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRecursive() {
        return this.isRecursive;
    }

    public void setRecursive(boolean isRecursive) {
        this.isRecursive = isRecursive;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public Model getParentModel() {
        return this.parentModel;
    }

    public void setParentModel(Model parentModel) {
        this.parentModel = parentModel;
    }

    public boolean isUsed() {
        return this.isUsed;
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public List<Model> getSubModels() {
        return this.subModels;
    }

    public void setSubModels(List<Model> subModels) {
        this.subModels = subModels;
    }

    public Model getSubModel(String modelName) {
        for (Model model : this.subModels) {
            if (!model.getName().equals(modelName)) continue;
            return model;
        }
        return null;
    }

    public Map<String, Field> getFieldPathMap() {
        return this.fieldPathMap;
    }

    public void setFieldPathMap(Map<String, Field> fieldPathMap) {
        this.fieldPathMap = fieldPathMap;
    }

    public Map<String, Model> getModelPathMap() {
        return this.modelPathMap;
    }

    public void setModelPathMap(Map<String, Model> modelPathMap) {
        this.modelPathMap = modelPathMap;
    }

    public Object getTargetBean() {
        return this.targetBean;
    }

    public void setTargetBean(Object targetBean) {
        this.targetBean = targetBean;
    }

    public void removeFieldByPath(String path) {
        Field field = this.fieldPathMap.get(path);
        Entity entity = field.getParentEntity();
        entity.getFields().remove(field);
    }

    public static void buildRelationForSubModel(Model parentModel, Model subModel) {
        subModel.setParentModel(parentModel);
        subModel.setFieldPathMap(parentModel.getFieldPathMap());
        subModel.setModelPathMap(parentModel.getModelPathMap());
        String parentModelPath = parentModel.getModelPath();
        if (subModel instanceof Entity) {
            subModel.setModelPath(parentModelPath.substring(0, parentModelPath.lastIndexOf("[")) + "[" + (parentModel.getSubModels().size() - 1) + "]");
            for (Field field : ((Entity)subModel).getFields()) {
                subModel.getFieldPathMap().put(subModel.getModelPath() + "." + field.getName(), field);
            }
        } else {
            subModel.setModelPath(parentModelPath + "." + subModel.getName() + "[]");
        }
        subModel.getModelPathMap().put(subModel.getModelPath(), subModel);
        List subSubModels = subModel.getSubModels();
        if (subSubModels != null) {
            for (Model subSubModel : subSubModels) {
                ModelImpl.buildRelationForSubModel(subModel, subSubModel);
            }
        }
    }

    public abstract Model clone();
}

