/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.impl.analyzers;

import com.github.jmodel.api.Field;
import com.github.jmodel.api.Model;
import com.github.jmodel.impl.AbstractAnalyzer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BeanAnalyzer
extends AbstractAnalyzer<Object> {
    public <T> Model process(Model sourceModel, T sourceObject, Boolean isConstruction) {
        this.build(sourceModel, new HashMap<String, Field>(), new HashMap<String, Model>(), sourceObject, isConstruction);
        return sourceModel;
    }

    @Override
    protected void setFieldValue(Object sourceNode, Field field) {
        try {
            Method m = sourceNode.getClass().getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
            field.setValue((String)m.invoke(sourceNode, new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Object getSubNode(Object node, String subNodeName) {
        try {
            Method m = node.getClass().getMethod("get" + StringUtils.capitalize((String)subNodeName), new Class[0]);
            return m.invoke(node, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void populateSubModel(Object subNode, Model subModel, Model subSubModel) {
        if (subNode instanceof List) {
            List subNodeList = (List)subNode;
            for (int i = 0; i < subNodeList.size(); ++i) {
                Object subSubJsonNode = subNodeList.get(i);
                Model clonedSubSubModel = null;
                if (i == 0) {
                    clonedSubSubModel = subSubModel;
                } else {
                    clonedSubSubModel = subSubModel.clone();
                    subModel.getSubModels().add(clonedSubSubModel);
                }
                clonedSubSubModel.setModelPath(subModel.getModelPath() + "." + clonedSubSubModel.getName() + "[" + i + "]");
                clonedSubSubModel.setFieldPathMap(subModel.getFieldPathMap());
                this.setValueOfFields(clonedSubSubModel, subModel.getFieldPathMap(), subModel.getModelPathMap(), subSubJsonNode);
            }
        }
    }

    @Override
    protected void buildModel(Model sourceModel, Map<String, Field> fieldPathMap, Map<String, Model> modelPathMap, String nodeName, Object node) {
    }
}

