/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.mapper.impl;

import com.github.jmodel.api.Analyzer;
import com.github.jmodel.api.AnalyzerFactoryService;
import com.github.jmodel.api.Array;
import com.github.jmodel.api.Entity;
import com.github.jmodel.api.Field;
import com.github.jmodel.api.FormatEnum;
import com.github.jmodel.api.IllegalException;
import com.github.jmodel.api.Model;
import com.github.jmodel.impl.ArrayImpl;
import com.github.jmodel.impl.EntityImpl;
import com.github.jmodel.impl.FieldImpl;
import com.github.jmodel.mapper.api.Builder;
import com.github.jmodel.mapper.api.Mapping;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractConvertEngine {
    protected ResourceBundle messages;
    protected static String DEFAULT_PACKAGE_NAME = "com.github.jmodel.mapper";
    protected static String NAME_PATTERN = "([a-zA-Z_][a-zA-Z\\d_]*\\.)*[a-zA-Z_][a-zA-Z\\d_]*";

    protected <T> Object getResult(T sourceObj, FormatEnum fromFormat, FormatEnum toFormat, Locale currentLocale) {
        AnalyzerFactoryService analyzerFactoryService = AnalyzerFactoryService.getInstance();
        Analyzer analyzer = analyzerFactoryService.getAnalyzer(fromFormat, null);
        Builder<?> builder = this.getBuilder(toFormat);
        Model model = analyzer.process((Model)new EntityImpl(), sourceObj, Boolean.valueOf(true));
        return builder.process(model);
    }

    protected Object getResult(Model model, FormatEnum toFormat, Locale currentLocale) {
        Builder<?> builder = this.getBuilder(toFormat);
        return builder.process(model);
    }

    protected <T> Object getResult(T sourceObj, String mappingURI, Map<String, Object> argsMap, Locale currentLocale) {
        Mapping mapping;
        Class<?> mappingClz;
        this.messages = ResourceBundle.getBundle("com.github.jmodel.mapper.api.MessagesBundle", currentLocale);
        if (mappingURI == null || !Pattern.matches(NAME_PATTERN, mappingURI)) {
            throw new IllegalException(this.messages.getString("M_NAME_IS_ILLEGAL"));
        }
        try {
            mappingClz = Class.forName(mappingURI);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalException(this.messages.getString("M_IS_MISSING"));
        }
        try {
            Method method = mappingClz.getMethod("getInstance", new Class[0]);
            mapping = (Mapping)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalException(this.messages.getString("M_IS_ILLEGAL"));
        }
        AnalyzerFactoryService analyzerFactoryService = AnalyzerFactoryService.getInstance();
        Analyzer analyzer = analyzerFactoryService.getAnalyzer(mapping.getFromFormat(), null);
        Builder<?> builder = this.getBuilder(mapping.getToFormat());
        if (mapping.getRawVariables().size() > 0) {
            if (argsMap == null || argsMap.size() == 0) {
                throw new IllegalException(this.messages.getString("V_NOT_FOUND"));
            }
            if (argsMap.keySet().parallelStream().filter(s -> mapping.getRawVariables().contains(s)).count() == 0L) {
                throw new IllegalException(this.messages.getString("V_NOT_FOUND"));
            }
        }
        Model sourceTemplateModel = mapping.getSourceTemplateModel();
        Model targetTemplateModel = mapping.getTargetTemplateModel();
        if (!mapping.isTemplateReady()) {
            this.populateModel(sourceTemplateModel, mapping.getRawSourceFieldPaths(), mapping.getSourceModelRecursiveMap());
            this.populateModel(targetTemplateModel, mapping.getRawTargetFieldPaths(), mapping.getTargetModelRecursiveMap());
            mapping.setTemplateReady(true);
        }
        Model sourceModel = analyzer.process(sourceTemplateModel.clone(), sourceObj, Boolean.valueOf(false));
        Model targetModel = targetTemplateModel.clone();
        this.fillTargetInstance(targetModel, new HashMap<String, Field>(), new HashMap<String, Model>());
        mapping.execute(sourceModel, targetModel, argsMap, currentLocale);
        this.cleanUnusedField(targetModel);
        return builder.process(targetModel);
    }

    private void fillTargetInstance(Model targetInstanceModel, Map<String, Field> targetFieldPathMap, Map<String, Model> targetModelPathMap) {
        if (targetInstanceModel != null) {
            List subModelList;
            List fieldList;
            targetInstanceModel.setFieldPathMap(targetFieldPathMap);
            targetInstanceModel.setModelPathMap(targetModelPathMap);
            if (targetInstanceModel.getModelPath() == null) {
                targetInstanceModel.setModelPath(targetInstanceModel.getName());
            }
            targetModelPathMap.put(targetInstanceModel.getModelPath(), targetInstanceModel);
            if (targetInstanceModel instanceof Entity && (fieldList = ((Entity)targetInstanceModel).getFields()) != null) {
                for (Field field : fieldList) {
                    field.setParentEntity((Entity)targetInstanceModel);
                    targetFieldPathMap.put(targetInstanceModel.getModelPath() + "." + field.getName(), field);
                }
            }
            if ((subModelList = targetInstanceModel.getSubModels()) != null) {
                for (Model subModel : subModelList) {
                    if (subModel instanceof Entity) {
                        subModel.setModelPath(subModel.getParentModel().getModelPath() + "." + subModel.getName());
                        this.fillTargetInstance(subModel, targetFieldPathMap, targetModelPathMap);
                    }
                    if (!(subModel instanceof Array)) continue;
                    subModel.setModelPath(targetInstanceModel.getModelPath() + "." + subModel.getName() + "[]");
                    subModel.setModelPathMap(targetModelPathMap);
                    subModel.setFieldPathMap(targetFieldPathMap);
                    targetModelPathMap.put(subModel.getModelPath(), subModel);
                    List subSubModelList = subModel.getSubModels();
                    for (int i = 0; i < subSubModelList.size(); ++i) {
                        Model entityInArray = (Model)subSubModelList.get(i);
                        entityInArray.setModelPath(targetInstanceModel.getModelPath() + "." + subModel.getName() + "[" + i + "]");
                        this.fillTargetInstance(entityInArray, targetFieldPathMap, targetModelPathMap);
                    }
                }
            }
        }
    }

    private void cleanUnusedField(Model targetModel) {
        List subModelList;
        if (targetModel instanceof Entity) {
            Entity currentEntity = (Entity)targetModel;
            ArrayList<Field> newFieldList = new ArrayList<Field>();
            List fieldList = currentEntity.getFields();
            if (fieldList != null) {
                for (Field field : fieldList) {
                    if (!field.isUsed()) continue;
                    newFieldList.add(field);
                }
            }
            currentEntity.setFields(newFieldList);
        }
        if ((subModelList = targetModel.getSubModels()) != null) {
            for (Model subModel : subModelList) {
                this.cleanUnusedField(subModel);
            }
        }
    }

    private void populateModel(Model root, List<String> fieldPaths, Map<String, Boolean> modelRecursiveMap) {
        HashMap<String, Object> modelOrFieldMap = new HashMap<String, Object>();
        for (String fieldPath : fieldPaths) {
            Field currentField;
            String[] paths = fieldPath.split("\\.");
            String currentPath = "";
            String parentPath = "";
            for (int i = 0; i < paths.length - 1; ++i) {
                currentPath = parentPath.equals("") ? paths[i] : parentPath.replace("[]", "[0]") + "." + paths[i];
                Model currentModel = (Model)modelOrFieldMap.get(currentPath);
                if (currentModel == null) {
                    Model parentModel;
                    Boolean recursive;
                    if (parentPath.equals("")) {
                        currentModel = root;
                    } else if (paths[i].indexOf("[]") != -1) {
                        currentModel = new ArrayImpl();
                        currentModel.setName(StringUtils.substringBefore((String)paths[i], (String)"[]"));
                    } else {
                        currentModel = new EntityImpl();
                        currentModel.setName(paths[i]);
                    }
                    if (currentModel.getName() == null) {
                        currentModel.setName(paths[i]);
                    }
                    if ((recursive = modelRecursiveMap.get(currentPath.replaceAll("\\[0\\]", "\\[\\]"))) != null && recursive.booleanValue()) {
                        currentModel.setRecursive(true);
                    }
                    currentModel.setModelPath(currentPath);
                    modelOrFieldMap.put(currentPath, currentModel);
                    if (currentModel instanceof Array) {
                        EntityImpl subEntity = new EntityImpl();
                        String entityName = StringUtils.substringBefore((String)paths[i], (String)"[]");
                        subEntity.setName(entityName);
                        currentPath = currentPath.replace("[]", "[0]");
                        subEntity.setModelPath(currentPath);
                        subEntity.setParentModel(currentModel);
                        currentModel.getSubModels().add(subEntity);
                        modelOrFieldMap.put(currentPath, subEntity);
                    }
                    if ((parentModel = (Model)modelOrFieldMap.get(parentPath.replaceAll("\\[\\]", "\\[0\\]"))) != null) {
                        currentModel.setParentModel(parentModel);
                        ArrayList<Model> subModelList = parentModel.getSubModels();
                        if (subModelList == null) {
                            subModelList = new ArrayList<Model>();
                            parentModel.setSubModels(subModelList);
                        }
                        subModelList.add(currentModel);
                    }
                }
                parentPath = currentPath;
            }
            String fieldName = paths[paths.length - 1];
            if (fieldName.equals("_") || (currentField = (Field)modelOrFieldMap.get(currentPath = currentPath + "." + fieldName)) != null) continue;
            currentField = new FieldImpl();
            currentField.setName(fieldName);
            modelOrFieldMap.put(currentPath, currentField);
            Entity currentModel = null;
            Object model = modelOrFieldMap.get(parentPath);
            if (model instanceof Entity) {
                currentModel = (Entity)model;
            } else if (model instanceof Array) {
                Array aModel = (Array)model;
                currentModel = (Entity)aModel.getSubModels().get(0);
            }
            ArrayList<Field> fieldList = currentModel.getFields();
            if (fieldList == null) {
                fieldList = new ArrayList<Field>();
                currentModel.setFields(fieldList);
            }
            fieldList.add(currentField);
        }
    }

    protected abstract Builder<?> getBuilder(FormatEnum var1);
}

