/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.mapper.impl.builders;

import com.github.jmodel.api.Array;
import com.github.jmodel.api.DataTypeEnum;
import com.github.jmodel.api.Entity;
import com.github.jmodel.api.Field;
import com.github.jmodel.api.IllegalException;
import com.github.jmodel.api.Model;
import com.github.jmodel.mapper.api.Builder;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BeanBuilder
implements Builder<Object> {
    public Object process(Model targetModel) {
        Object bean = targetModel.getTargetBean();
        if (bean == null) {
            throw new IllegalException("no bean instance found");
        }
        this.buildBean(targetModel, bean);
        return bean;
    }

    private void buildBean(Model model, Object bean) {
        Method getM = null;
        Method setM = null;
        try {
            List subModels;
            List fields;
            if (model instanceof Entity && (fields = ((Entity)model).getFields()) != null) {
                for (Field field : fields) {
                    DataTypeEnum dataType = field.getDataType();
                    if (dataType == null) {
                        field.setDataType(DataTypeEnum.STRING);
                    }
                    switch (field.getDataType()) {
                        case INTEGER: {
                            setM = bean.getClass().getMethod("set" + StringUtils.capitalize((String)field.getName()), Integer.class);
                            setM.invoke(bean, Integer.valueOf(field.getValue()));
                        }
                        case LONG: {
                            setM = bean.getClass().getMethod("set" + StringUtils.capitalize((String)field.getName()), Long.class);
                            setM.invoke(bean, Long.valueOf(field.getValue()));
                        }
                        case BOOLEAN: {
                            setM = bean.getClass().getMethod("set" + StringUtils.capitalize((String)field.getName()), Boolean.class);
                            setM.invoke(bean, Boolean.valueOf(field.getValue()));
                        }
                        case BIGDECIMAL: {
                            setM = bean.getClass().getMethod("set" + StringUtils.capitalize((String)field.getName()), BigDecimal.class);
                            setM.invoke(bean, new BigDecimal(field.getValue()));
                        }
                        case DATE: {
                            setM = bean.getClass().getMethod("set" + StringUtils.capitalize((String)field.getName()), Date.class);
                            SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-DD");
                            Date date = format.parse(field.getValue());
                            setM.invoke(bean, date);
                        }
                    }
                    setM = bean.getClass().getMethod("set" + StringUtils.capitalize((String)field.getName()), String.class);
                    setM.invoke(bean, field.getValue());
                }
            }
            if ((subModels = model.getSubModels()) != null) {
                for (Model subModel : subModels) {
                    if (subModel instanceof Entity) {
                        getM = bean.getClass().getMethod("get" + StringUtils.capitalize((String)subModel.getName()), new Class[0]);
                        setM = bean.getClass().getMethod("set" + StringUtils.capitalize((String)subModel.getName()), getM.getReturnType());
                        Object obj = getM.getReturnType().newInstance();
                        setM.invoke(bean, obj);
                        this.buildBean(subModel, obj);
                        continue;
                    }
                    if (!(subModel instanceof Array)) continue;
                    getM = bean.getClass().getMethod("get" + StringUtils.capitalize((String)subModel.getName()), new Class[0]);
                    setM = bean.getClass().getMethod("set" + StringUtils.capitalize((String)subModel.getName()), List.class);
                    Type type = ((ParameterizedType)getM.getGenericReturnType()).getActualTypeArguments()[0];
                    ArrayList subBeans = new ArrayList();
                    setM.invoke(bean, subBeans);
                    List sub = subModel.getSubModels();
                    if (sub == null) continue;
                    for (Model subSubModel : sub) {
                        Object subBean = Class.forName(type.getTypeName()).newInstance();
                        subBeans.add(subBean);
                        this.buildBean(subSubModel, subBean);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalException("something wrong");
        }
    }
}

