/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.mapper.impl.builders;

import com.github.jmodel.api.FormatEnum;
import com.github.jmodel.mapper.api.Builder;
import com.github.jmodel.mapper.impl.builders.BeanBuilder;
import com.github.jmodel.mapper.impl.builders.JsonNodeBuilder;
import com.github.jmodel.mapper.impl.builders.JsonStringBuilder;
import com.github.jmodel.mapper.impl.builders.XmlStringBuilder;
import com.github.jmodel.mapper.spi.BuilderFactory;

public class BuilderFactoryImpl
implements BuilderFactory {
    public <R> Builder<R> getBuilder(FormatEnum toFormat, Class<R> returnType) {
        switch (toFormat) {
            case JSON: {
                if (returnType.getName().equals("com.fasterxml.jackson.databind.JsonNode")) {
                    return new JsonNodeBuilder();
                }
                if (returnType.getName().equals("java.lang.String")) {
                    return new JsonStringBuilder();
                }
            }
            case XML: {
                if (returnType.getName().equals("java.lang.String")) {
                    return new XmlStringBuilder();
                }
            }
            case BEAN: {
                if (!returnType.getName().equals("java.lang.Object")) break;
                return new BeanBuilder();
            }
        }
        return null;
    }
}

