/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.mapper.impl.builders;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.jmodel.api.Array;
import com.github.jmodel.api.Entity;
import com.github.jmodel.api.Field;
import com.github.jmodel.api.Model;
import java.util.List;

public class JsonBuilderHelper {
    private static final JsonNodeFactory jsonNodeFactory = JsonNodeFactory.instance;

    public static final JsonNode buildJsonNode(Model targetModel) {
        ObjectNode rootNode = jsonNodeFactory.objectNode();
        JsonBuilderHelper.createJsonNode(jsonNodeFactory, rootNode, targetModel);
        return rootNode;
    }

    private static final JsonNode createJsonNode(JsonNodeFactory factory, ObjectNode node, Model model) {
        if (model != null) {
            List subModels;
            List fields = ((Entity)model).getFields();
            if (fields != null) {
                for (Field field : fields) {
                    node.put(field.getName(), field.getValue());
                }
            }
            if ((subModels = model.getSubModels()) != null) {
                for (Model subModel : subModels) {
                    if (subModel instanceof Entity) {
                        ObjectNode subNode = factory.objectNode();
                        node.set(subModel.getName(), JsonBuilderHelper.createJsonNode(factory, subNode, subModel));
                        continue;
                    }
                    if (!(subModel instanceof Array)) continue;
                    List sub = subModel.getSubModels();
                    ArrayNode sNode1 = factory.arrayNode();
                    for (Model s : sub) {
                        ObjectNode sNode2 = factory.objectNode();
                        sNode1.add(JsonBuilderHelper.createJsonNode(factory, sNode2, s));
                    }
                    node.set(subModel.getName(), (JsonNode)sNode1);
                }
            }
        }
        return node;
    }
}

