/*
 * Decompiled with CFR 0.152.
 */
package com.github.jmodel.mapper.impl.builders;

import com.github.jmodel.api.Array;
import com.github.jmodel.api.Entity;
import com.github.jmodel.api.Field;
import com.github.jmodel.api.Model;
import com.github.jmodel.mapper.api.Builder;
import java.io.StringWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlStringBuilder
implements Builder<String> {
    public String process(Model targetModel) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        Document xmlDoc = documentBuilder.newDocument();
        this.generateXml(targetModel, xmlDoc, null);
        StringWriter stringWriter = new StringWriter();
        try {
            DOMSource source = new DOMSource(xmlDoc);
            StreamResult result = new StreamResult(stringWriter);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }

    private void generateXml(Model model, Document document, Element parent) {
        List subModel;
        List fields;
        Element element = document.createElement(model.getName());
        if (parent != null) {
            parent.appendChild(element);
        } else {
            document.appendChild(element);
        }
        if (model instanceof Entity && (fields = ((Entity)model).getFields()) != null) {
            for (Field field : fields) {
                Element fieldElement = document.createElement(field.getName());
                fieldElement.appendChild(document.createTextNode(field.getValue()));
                element.appendChild(fieldElement);
            }
        }
        if ((subModel = model.getSubModels()) != null) {
            for (Model subModels : subModel) {
                List sub;
                if (subModels instanceof Entity) {
                    this.generateXml(subModels, document, element);
                    continue;
                }
                if (!(subModels instanceof Array) || (sub = subModels.getSubModels()) == null) continue;
                for (Model s : sub) {
                    this.generateXml(s, document, element);
                }
            }
        }
    }
}

